package com.elitesland.fin.application.web.paymentperiod;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.*;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.application.service.paymentperiod.AgingRangeDtlService;
import com.elitesland.fin.application.service.paymentperiod.AgingRangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/agingRange")
@RequiredArgsConstructor
@Api(value = "账龄区间设置", tags = {"账龄区间设置"})
public class AgingRangeController {

    private final AgingRangeService agingRangeService;

    private final AgingRangeDtlService agingRangeDtlService;


    @PostMapping("save")
    @ApiOperation("新增-账龄区间")
    public ApiResult<Long> save(@RequestBody AgingRangeSaveParam saveParam) {
        Long id = agingRangeService.save(saveParam);
        return ApiResult.ok(id);
    }

    @PostMapping("/page")
    @ApiOperation("账龄区间分页查询")
    public ApiResult<PagingVO<AgingRangePagingVO>> page(@RequestBody AgingRangePageParam pageParam) {
        PagingVO<AgingRangePagingVO> page = agingRangeService.page(pageParam);
        return ApiResult.ok(page);
    }

    @GetMapping("/findIdOne/{id}")
    @ApiOperation("根据账龄区间ID查询账龄区间详情数据")
    public ApiResult<AgingRangeVO> findIdOne(@PathVariable Long id) {
        AgingRangeVO agreementVO = agingRangeService.findIdOne(id);
        return ApiResult.ok(agreementVO);
    }

    @GetMapping("/findCodeOne/{code}")
    @ApiOperation("根据账龄区间编码查询账龄区间详情数据")
    public ApiResult<AgingRangeVO> findCodeOne(@PathVariable String code) {
        AgingRangeVO agreementVO = agingRangeService.findCodeOne(code);
        return ApiResult.ok(agreementVO);
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据账龄区间ID批量删除")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        agingRangeService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping("/enable")
    @ApiOperation("根据账龄区间ID批量启用")
    public ApiResult<List<Long>> enableBatch(@RequestBody List<Long> ids) {
        agingRangeService.enableBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping("/disable")
    @ApiOperation("根据账龄区间ID批量停用")
    public ApiResult<List<Long>> disableBatch(@RequestBody List<Long> ids) {
        agingRangeService.disableBatch(ids);
        return ApiResult.ok();
    }


    @PostMapping("/common/page")
    @ApiOperation("账龄区间公共分页查询")
    public ApiResult<PagingVO<AgingRangeComPagingVO>> commonPage(@RequestBody AgingRangeComPageParam pageParam) {
        PagingVO<AgingRangeComPagingVO> page = agingRangeService.commonPage(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/ouPage")
    @ApiOperation("分页查询账龄区间的分配公司")
    public ApiResult<PagingVO<AgingRangeOuVO>> ouPage(@RequestBody AgingRangeOuPageParam pageParam) {
        PagingVO<AgingRangeOuVO> res = agingRangeService.ouPage(pageParam);
        return ApiResult.ok(res);
    }

    @ApiOperation("添加分配公司")
    @PostMapping("/addOu")
    public ApiResult<Boolean> addOu(@RequestBody AgingRangeOuMainSaveParam saveParam) {
        agingRangeService.addOu(saveParam);
        return ApiResult.ok();
    }

    @PostMapping("cancelOu")
    @ApiOperation("/取消分配公司")
    public ApiResult<Boolean> cancelOu(@RequestBody List<Long> ids) {
        agingRangeService.cancelOu(ids);
        return ApiResult.ok();
    }

}
