package com.elitesland.fin.application.web.workflow;


import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedSaveRespVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.service.AisinoApplyPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoApplyPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedPayload;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoApplyRespVO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "INVOICE_REDRAFT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class InvoiceRedraftCallbackController implements WorkflowCallBack {

    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceApplyService invoiceApplyService;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final InvoiceSaveService invoiceSaveService;
    private final AisinoService aisinoService;
    private final SaleInvRepoProc saleInvRepoProc;
    private final AisinoApplyPayloadService aisinoApplyPayloadService;
    /**
     * 查询单据
     */
    private InvoiceRedraftDO getInvRedraftDO(String businessKey) {
        Long masId = Long.valueOf(businessKey.split("#")[1].trim());
        Optional<InvoiceRedraftDO> byId = invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new RuntimeException("重新开票(id:" + masId + ")不存在，无法审批");
        }
        return byId.get();
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(new ArrayList<>());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}", payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    private static String getDecryptedData(String encryptedData) {
        // 解密秘钥
        String key = "12345678";
        // 将16进制字符串转换为字节数组
        byte[] encryptedBytes = InvoiceIssueUtil.parseHexStr2Byte(encryptedData);
        if (encryptedBytes == null) {
            throw new RuntimeException("解密失败,加密数据格式错误，加密数据:" + encryptedData);
        }
        // 解密数据
        try {
            byte[] decryptedBytes = InvoiceIssueUtil.decrypt(encryptedBytes, key);
            return InvoiceIssueUtil.byteToHexString(decryptedBytes);
        } catch (Exception e) {
            throw new RuntimeException("解密失败,解密过程异常，加密数据:" + encryptedData, e);
        }
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        /**
         * 验证数据
         */
        //1,单据是否存在
        InvoiceRedraftDO invoiceRedraftDO = getInvRedraftDO(payload.getBusinessKey());

        /**
         * 修改单据
         */
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qdo)
                .set(qdo.workflowProcInstStatus, procInstStatus) //审批状态
                .where(qdo.id.eq(invoiceRedraftDO.getId()));

        JPAUpdateClause saleInvdDtlDOJpaUpdateClause = jpaQueryFactory.update(qSaleInvdDtlDO)
                .where(qSaleInvdDtlDO.invNo.eq(invoiceRedraftDO.getInvoiceNo()));

        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//未生效

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//草稿
                jpaUpdateClause.setNull(qdo.workflowProcInstId);//清空流程实例ID
                jpaUpdateClause.setNull(qdo.workflowProcInstStatus);//清空流程实例状态

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_REJECTED.getValueCode());//未生效
//                jpaUpdateClause.set(QFranchiseeApplyDO.franchiseeApplyDO.workflowRejectedMessage, commentInfo.getComment());
//                jpaUpdateClause.setNull(qFranchiseeApplyDO.workflowProcInstId);//清空流程实例ID
                //messageHandleUtils.sendFranchiseeApplyRejectMsg(franchiseeApplyDO);
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.REJECTED);

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());//已作废

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_DOING.getValueCode());//未生效
                //审批状态
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.APPROVING);

                saleInvdDtlDOJpaUpdateClause.set(qSaleInvdDtlDO.invoiceRedraftState, UdcEnum.APPLY_STATUS_DOING.getValueCode());
                break;
            case APPROVED: // 审批通过
                //查询票易通该单据的状态，若为红冲状态，则进行重新开票的生成
                jpaUpdateClause.setNull(qdo.workflowCurrentNodeName);//清空当前审批节点名称
                jpaUpdateClause.setNull(qdo.workflowCurrentNodeKey);//清空当前审批节点key
                jpaUpdateClause.setNull(qdo.workflowCurrentUserIds);//清空当前审批人
                jpaUpdateClause.set(qdo.docStatus, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());//已生效
                jpaUpdateClause.set(qdo.workflowEndTime, LocalDateTime.now());//审批完成时间
                jpaUpdateClause.set(qdo.workflowProcInstStatus, ProcInstStatus.APPROVED);//审批状态

                // 调用航信接口，发送红冲请求
                SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                List<SaleInvdDtlVO> saleInvdDtlVOs = saleInvService.getInvdLists(saleInvDO.getId());
                if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
                    // 开票申请单
                    InvoiceApplyRpcDTO applyRpcDTO = invoiceApplyService.queryIdByApplyNo(invoiceRedraftDO.getOrigApplyNo());
                    SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
                    // 组装红冲接口入参
                    InvoiceRedApplySaveParam saveParam = new InvoiceRedApplySaveParam();
                    saveParam.setOriginApplyNo(invoiceRedraftDO.getOrigApplyNo());
                    saveParam.setSaleTaxNo(saleInvDO.getSaleTaxNo());
                    saveParam.setCustTaxNo(saleInvDO.getCustTaxNo());
                    saveParam.setInvType(saleInvDO.getInvType());
                    saveParam.setInvDate(saleInvdDtlVO.getInvDate());
                    // 红票申请
                    aisinoRedMethod(saveParam, applyRpcDTO.getApplyNo());
                    // 审批通过且红冲成功，生成开票申请单
                }

                // todo lance 发送邮件 审批通过后发送通知信息给创建人
                break;
        }
        //执行
        jpaUpdateClause.execute();
        saleInvdDtlDOJpaUpdateClause.execute();

        return WorkflowResult.success(null);
    }

    /**
     * 航信红冲接口
     *
     * @param saveParam
     * @param applyNo
     */
    public void aisinoRedMethod(InvoiceRedApplySaveParam saveParam, String applyNo) {
        AisinoRedPayload aisinoRedPayload = aisinoApplyPayloadService.convertRedInitial(saveParam);
        AisinoApplyPayload aisinoApplyPayload = aisinoApplyPayloadService.assembleAisinoPayload(JSON.toJSONString(aisinoRedPayload), saveParam.getSaleTaxNo());
        // 红票确认单初始化
        AisinoApplyRespVO response = aisinoService.redInvoiceInitial(aisinoApplyPayload);
        String data = response.getDATA();
        // 初始化结果
        if (data != null && !data.isEmpty()) {
            // 初始化结果data 需要解密
            String decryptedData = getDecryptedData(data);
            InvoiceRedInitialRespVO invoiceRedInitialRespVO = JSON.parseObject(decryptedData, InvoiceRedInitialRespVO.class);
            // todo lance 红票确认单初始化结果，需要保存

            // 如果2.2.2.4响应数据中QRJKPBZ = Y（是否确认即开票标志）,表示当“申请红字确认单保存时”或“购/销方确认后”，会自动开具红票，则不必再使用2.2.2.6红字发票开具接口.
            if (Objects.equals(invoiceRedInitialRespVO.getQRJKPBZ(), "Y")) {
                // 通过红票确认单保存
                AisinoRedPayload aisinoRedPayload1 = aisinoApplyPayloadService.convertRedSave(invoiceRedInitialRespVO);
                AisinoApplyPayload aisinoApplyPayload1 = aisinoApplyPayloadService.assembleAisinoPayload(JSON.toJSONString(aisinoRedPayload1), saveParam.getSaleTaxNo());
                AisinoApplyRespVO response2 = aisinoService.redInvoiceSave(aisinoApplyPayload1);
                InvoiceRedInitialRespVO invoiceRedInitialRespVO2 = JSON.parseObject(getDecryptedData(response2.getDATA()), InvoiceRedInitialRespVO.class);

                // 红票确认单保存后，直接等待是否开票完成
            } else {
                // 通过红票确认单保存
                AisinoRedPayload aisinoRedPayload1 = aisinoApplyPayloadService.convertRedSave(invoiceRedInitialRespVO);
                AisinoApplyPayload aisinoApplyPayload1 = aisinoApplyPayloadService.assembleAisinoPayload(JSON.toJSONString(aisinoRedPayload1), saveParam.getSaleTaxNo());
                AisinoApplyRespVO response2 = aisinoService.redInvoiceSave(aisinoApplyPayload1);
                InvoiceRedSaveRespVO invoiceRedSaveRespVO = JSON.parseObject(getDecryptedData(response2.getDATA()), InvoiceRedSaveRespVO.class);

                InvoiceRedSaveRespVO.Data saveRespVODATA = invoiceRedSaveRespVO.getDATA();
                InvoiceRedSaveRespVO.Qrjkpfpqx qrjkpfpxx = saveRespVODATA.getQRJKPFPXX();

                // 调用红票开具接口
                AisinoRedInvoiceParam aisinoRedInvoiceParam = new AisinoRedInvoiceParam();
                aisinoRedInvoiceParam.setUUID(saveRespVODATA.getUUID());
                //税号 +随机数 长度为30 唯一值
                aisinoRedInvoiceParam.setFPQQLSH(qrjkpfpxx.getXSFNSRSBH()+ RandomUtil.randomNumbers(30));
                aisinoRedInvoiceParam.setYFPHM(qrjkpfpxx.getFPHM());
                aisinoRedInvoiceParam.setHZFPXXQRDBH(saveRespVODATA.getHZFPXXQRDBH());
                aisinoRedInvoiceParam.setSFZZFP("N");
                aisinoRedInvoiceParam.setZZFPHM("");
                aisinoRedInvoiceParam.setFPDM("");
                aisinoRedInvoiceParam.setFPZLDM("");
                aisinoRedInvoiceParam.setXSFNSRSBH("");
                aisinoRedInvoiceParam.setTDYSLXDM("");

                AisinoRedPayload aisinoRedPayload2 = aisinoApplyPayloadService.convertRedOpen(aisinoRedInvoiceParam);
                AisinoApplyPayload aisinoApplyPayload2 = aisinoApplyPayloadService.assembleAisinoPayload(JSON.toJSONString(aisinoRedPayload2), saveParam.getSaleTaxNo());
                AisinoApplyRespVO response3 = aisinoService.redInvoiceOpen(aisinoApplyPayload2);
                InvoiceRedInitialRespVO invoiceRedInitialRes3 = JSON.parseObject(getDecryptedData(response3.getDATA()), InvoiceRedInitialRespVO.class);
                // 等待回调是否开票完成
            }


        }

        // 更新红票结果
        saleInvRepoProc.updateExternalInfo(applyNo, response.getCODE(), response.getMSG());
    }

}
