package com.elitesland.fin.infinity.aisino.controller;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.notice.InvoiceParam;
import com.elitesland.fin.utils.BeanUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@Api(tags = "航信接口")
@RestController
@RequestMapping(value = "/aisino", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class AisinoController {

    private final AisinoService aisinoService;

    @PostMapping("/fin/invoice")
    @ApiOperation("销项发票协同接口")
    public ApiResult<?> saveInvoice(@RequestBody JSONObject param) {
        log.info("step aisino invoice: {}", JSON.toJSONString(param));
        aisinoService.invoiceLog(param.toJSONString(2));
        InvoiceParam invoiceParam = BeanUtils.toBean(param, InvoiceParam.class);
        aisinoService.saveInvoice(invoiceParam);
        return ApiResult.ok();
    }

    @PostMapping("/invoice/notice")
    @ApiOperation("开具结果反馈接口")
    public ApiResult<?> notice(@RequestBody JSONObject param) {
        log.info("step aisino notice: {}", JSON.toJSONString(param));
        aisinoService.noticeLog(param.toJSONString(2));
        return ApiResult.ok();
    }
}
