package com.elitesland.fin.infinity.http.param;

import lombok.Data;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.Map;

/**
 * 接口请求参数
 *
 * @author eric.hao
 * @since 2021/08/04
 */
@Data
public class HttpParam<T, K> {

    /**
     * 接口地址
     */
    private String url;

    /**
     * 接口请求头
     */
    private Map<String, String> headers;

    /**
     * 接口参数
     */
    private Map<String, Object> body;

    /**
     * 请求方式
     */
    @Enumerated(EnumType.STRING)
    private RequestMethod requestMethod;

    /**
     * 请求头的媒体类型
     */
    @Enumerated(EnumType.STRING)
    private MediaType mediaType = MediaType.APPLICATION_JSON;

    /**
     * 响应值的实体类型
     */
    private Class<K> responseType;

    /**
     * 返回数据结果的实体类型
     */
    private Class<T> resultType;
}

