package com.elitesland.fin.application.facade.param.creditaccount;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 账户表;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "信用设置参数")
public class CreditSettingParam extends BaseModelParam {

    @ApiModelProperty(value = "叠加参数")
    private String extraParam;

    @ApiModelProperty(value = "常规参数")
    private String generalParam;

    @ApiModelProperty(value = "启用标识")
    private Boolean enableFlag;

    @ApiModelProperty(value = "自动还款设置标志")
    private Boolean autoRepaymentFlag;

    @ApiModelProperty(value = "自动还款设置条件明细")
    private List<CreditAutoRepaymentConditionSaveParam> autoRepaymentParamList;

    @ApiModelProperty(value = "账期检查设置标识")
    private Boolean paymentPeriodFlag;

}
