package com.elitesland.fin.domain.service.expense;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;

import java.util.List;
import java.util.Optional;


/**
 * @author Mark
 * @date 2024/08/13 18:23
 */
public interface ExpRuleConfigDomainService {
    void updateDynamically(ExpRuleConfigDO ExpRuleConfigDO);

    PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param);

    List<ExpRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode);

    ExpRuleConfigDTO findByRuleCode(String ruleCode);

    void deleteById(Long id);

    Optional<ExpRuleConfigDO> findById(Long id);

    List<ExpRuleConfigDO> findByIds(List<Long> ids);

    Boolean updateEnableFlag(List<Long> ids, boolean enable);
}
