package com.elitesland.fin.infinity.aisino.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


@Entity
@Table(name = "aisino_req_log")
@org.hibernate.annotations.Table(appliesTo = "aisino_req_log", comment = "航信请求参数日志")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "航信请求参数日志", description = "航信请求参数日志")
@Where(clause = "delete_flag = 0")
public class AisinoLogDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2568848705194644670L;

    @Comment(value = "接口类型")
    @Column()
    private String requestType;

    @Comment(value = "接口类型中文")
    @Column()
    private String requestTypeName;

    @Comment(value = "接口入参")
    @Column(columnDefinition = "MEDIUMTEXT")
    private String requestParam;
}
