package com.elitesland.fin.infr.repo.payorder;

import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;

import java.math.BigDecimal;
import java.util.List;

import feign.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:44
 */
@Repository
public interface PayOrderDtlRepo extends JpaRepository<PayOrderDtlDO, Long>, QuerydslPredicateExecutor<PayOrderDtlDO> {


    /**
     * 根据主表id查询应收单明细记录表
     * @param masId 主表id
     * @return
     */
    List<PayOrderDtlDO> findAllByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update pay_order_dtl set modify_time = CURRENT_TIMESTAMP, " +
            " audit_data_version = :version + 1, ver_amt = :verAmt, ver_amting = :verAmting, un_ver_amt = :unVerAmt where id =:payOrderDtlId and " +
            " audit_data_version = :version and delete_flag != 1", nativeQuery = true)
    int updateExtVerAmt(@Param("payOrderDtlId") Long payOrderDtlId, @Param("version") Integer version
            , @Param("verAmt") BigDecimal verAmt, @Param("verAmting") BigDecimal verAmting, @Param("unVerAmt") BigDecimal unVerAmt);
}
