package com.elitesland.fin.application.service.payment;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;

import java.util.List;
import java.util.Optional;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface PaymentRuleConfigService {
    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<PaymentRuleConfigPageVO> searchPage(PaymentRuleConfigParam param);

    Optional<PaymentRuleConfigQueryVO> byRuleCode(String ruleCode);

    List<PaymentRuleConfigDtlDTO> dtlsByRuleCode(String ruleCode);

    /**
     * 保存/更新
     * @param param
     */
    void saveOrUpdate(PaymentRuleConfigParam param);

    /**
     * 删除主+明细信息
     * @param id
     */
    void del(Long id);

    /**
     * 详情信息
     * @param masId
     * @return
     */
    PaymentRuleConfigQueryVO detail(Long masId);

    /**
     * 根据场景码获取账户规则操作配置，优先缓存
     * @param ruleCode
     * @return
     */
    PaymentRuleConfigDTO getByRuleCode(String ruleCode);

    List<PaymentRuleConfigDtlDTO> queryAccountAmount(PaymentRuleConfigParam param);

    List<PaymentRuleConfigDtlDTO> pay(PaymentRuleConfigParam param);
}
