package com.elitesland.fin.application.service.paymentperiod;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementComPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
public interface ReceiptPaymentAgreementService {

    /**
     * 新增-收付款协议
     *
     * @param saveParam 入参
     * @return
     */
    Long save(ReceiptPaymentAgreementSaveParam saveParam);

    /**
     * 新增-收付款协议
     *
     * @param saveParam 入参
     * @return
     */
    Long update(ReceiptPaymentAgreementSaveParam saveParam);


    /**
     * 收付款协议分页查询
     *
     * @param pageParam 入参
     * @return 收付款协议信息集合
     */
    PagingVO<ReceiptPaymentAgreementPagingVO> page(ReceiptPaymentAgreementPageParam pageParam);

    /**
     * 根据收付款协议ID查询收付款协议详情数据
     *
     * @param id 收付款协议ID
     * @return 收付款协议详情数据
     */
    ReceiptPaymentAgreementVO findIdOne(Long id);

    /**
     * 根据收付款协议编码查询收付款协议详情数据
     *
     * @param code 收付款协议编码
     * @return 收付款协议详情数据
     */
    ReceiptPaymentAgreementVO findCodeOne(String code);

    /**
     * 根据收付款协议ID批量删除
     *
     * @param ids 收付款协议ID集合
     * @return
     */
    void deleteBatch(List<Long> ids);


    /**
     * 根据收付款协议ID批量启用
     *
     * @param ids 收付款协议ID集合
     * @return
     */
    void enableBatch(List<Long> ids);

    /**
     * 根据收付款协议ID批量停用
     *
     * @param ids 收付款协议ID集合
     * @return
     */
    void disableBatch(List<Long> ids);

    /**
     * 收款协议公共分页查询
     *
     * @param pageParam 入参
     * @return 收款协议信息集合
     */
    PagingVO<ReceiptPaymentAgreementComPagingVO> receiptCommonPage(ReceiptPaymentAgreementComPageParam pageParam);

    /**
     * 付款协议公共分页查询
     *
     * @param pageParam 入参
     * @return 付款协议信息集合
     */
    PagingVO<ReceiptPaymentAgreementComPagingVO> paymentCommonPage(ReceiptPaymentAgreementComPageParam pageParam);

    /**
     * 收付款协议公共分页查询
     *
     * @param pageParam 入参
     * @return 收付款协议信息集合
     */
    PagingVO<ReceiptPaymentAgreementComPagingVO> commonPage(ReceiptPaymentAgreementComPageParam pageParam);
}
