package com.elitesland.fin.application.service.workflow.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.aporder.ApOrderDtlGroupSaveParam;
import com.elitesland.fin.application.facade.param.aporder.ApOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aptype.ApTypeVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.aptype.ApTypeService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;


/**
 * @author zhiyu.he
 * @date 2022/5/7 13:25
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ArOrderProcessServiceImpl implements ArOrderProcessService {


    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderRepo arOrderRepo;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;

    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final TaskExecutor taskExecutor;
    private final ArOrderDomainService arOrderDomainService;

    private final RmiSaleRpcService rmiSaleRpcService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderService apOrderService;
    private final ApTypeService apTypeService;

    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PurSuppOutService purSuppOutService;


    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMasIds(List.of(id));
        //ArOrderDO newArOrderDO = arOrderRepo.findById(id).get();
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        //ArOrderDTO arOrderDTO = ArOrderConvert.INSTANCE.doConvertToDto(newArOrderDO);

        QArOrderDO qRecOrderDO = QArOrderDO.arOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.procInstStatus, procInstStatus)
                .where(qRecOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交   状态为草稿
            case NOTSUBMIT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.procInstId, (String) null);
                break;
                //审批中
            case APPROVING:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(qRecOrderDO.submitTime,LocalDateTime.now());
                break;
            // 审批拒绝 业务数据为草稿
            case REJECTED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.procInstId, (String) null)
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName())
                        .set(qRecOrderDO.procInstId, (String) null);

                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(qRecOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                    .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                //触发自动核销
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            // 手工生成的应收单并且客户=外部客户，需要生成财务流水
            if ("OUT".equals(arOrderDTO.getInOutCust()) && "MANU".equals(arOrderDTO.getCreateMode())){
                arOrderDTO.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
                arOrderDomainService.createFinFlow(arOrderDTO);
            }

            //获取客户类型
            String custType2 = getCustType2(arOrderDTO);
            List<ApOrderDO> data = apOrderRepoProc.queryBySourceNo(arOrderDTO.getArOrderNo());
            //应收单的客户类型=系统内，审批通过后同步生成审批通过的应付单。如果应付单中来源单号已经有此应收单，禁止生成。
            if ("C".equals(custType2) && "MANU".equalsIgnoreCase(arOrderDTO.getCreateMode())) {
                if (CollUtil.isEmpty(data)) { //没有关联的收款单
                    ApOrderSaveParam apOrderSaveParam = getApOrderSaveParam(arOrderDTO, arOrderDtlDTOS);
                    apOrderService.save(apOrderSaveParam);
                }
            }

            //异步
            CompletableFuture.runAsync(() ->{
                //自动核销
                log.info("应收单审批通过，开始自动核销");
                finArRecVerApplyService.autoWriteoffAr(arOrderDTO);
                //处理核销状态
                updateVerState(id);
            }, taskExecutor);

        }

    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<ApTypeVO> apTypeVOList = apTypeService.getList().computeData();
        Optional<ApTypeVO> first = apTypeVOList.stream().filter(e -> e.getApTypeCode().equals(code)).findFirst();
        return first.map(ApTypeVO::getId).orElse(null);
    }


    private ApOrderSaveParam getApOrderSaveParam(ArOrderDTO arOrderDTO, List<ArOrderDtlDTO> arOrderDtlDTOS) {
        log.info("生成应付单入参:arOrderDTO:{},recOrderDtlDTOS:{}", JSONUtil.toJsonStr(arOrderDTO),
                JSONUtil.toJsonStr(arOrderDtlDTOS));
        //获取客户信息
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(arOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("应收单客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("客户信息:{}", JSONUtil.toJsonStr(custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("客户关联公司编码:{}", corBusinCode);
        if (StrUtil.isBlank(corBusinCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("应收单客户对应的公司编码不存在");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes =
                rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("应收单客户对应的公司信息不存在");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("客户关联公司信息:{}", JSONUtil.toJsonStr(orgOuRpcSimpleDTO));

        //获取公司关联的供应商信息
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(arOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("应收单公司关联的供应商不存在");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);

        ApOrderSaveParam param = new ApOrderSaveParam();
        param.setTaxFlag(true);
        //内外部
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());

        param.setCurrCode(StrUtil.isNotBlank(arOrderDTO.getCurrCode()) ? arOrderDTO.getCurrCode() : "CNY");
        param.setCurrName(StrUtil.isNotBlank(arOrderDTO.getCurrName()) ? arOrderDTO.getCurrName() : "人民币");
        param.setLocalCurrCode(StrUtil.isNotBlank(arOrderDTO.getLocalCurrCode()) ? arOrderDTO.getLocalCurrCode() :
                "CNY");
        param.setLocalCurrName(StrUtil.isNotBlank(arOrderDTO.getLocalCurrName()) ? arOrderDTO.getLocalCurrName() :
                "人民币");

        //公司
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        //供应商
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        //来源系统单号
        param.setSourceNo(arOrderDTO.getArOrderNo());
        //应付单类型
        param.setApTypeCode("YFD01_SYS");
        param.setApTypeName("标准应付单");
        param.setApTypeId(getApTypeIdByCode("YFD01_SYS"));
        //来源单据
        param.setCreateMode("AR");
        //业务日期
        param.setBuDate(arOrderDTO.getBuDate());
        //关联公司
        param.setRelevanceOuCode(arOrderDTO.getOuCode());
        //收款协议编码->客户上维护的收款协议
        param.setProtocolCode(arOrderDTO.getProtocolCode());
        //汇率
        param.setExchangeRate(arOrderDTO.getExchangeRate());
        //含税金额
        param.setTotalAmt(arOrderDTO.getTotalAmt());
        //含税金额（本位币)
        param.setTotalCurAmt(arOrderDTO.getTotalCurAmt());
        //不含税金额
        param.setExclTaxAmt(arOrderDTO.getExclTaxAmt());
        //不含税金额（本位币）
        param.setExclTaxCurAmt(arOrderDTO.getExclTaxCurAmt());
        //税额
        param.setTaxAmt(arOrderDTO.getTaxAmt());
        //税额(本位币)
        param.setTaxCurAmt(arOrderDTO.getTaxCurAmt());

        //是否期初
        param.setInitFlag(arOrderDTO.getInitFlag());
        //汇率
        param.setExchangeRate(arOrderDTO.getExchangeRate());
        //状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(arOrderDTO.getRedState());
        //红冲对应原单号
        String redSourceNo = arOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank(redSourceNo)) {
            List<ApOrderDO> apOrderDOS = apOrderRepoProc.queryBySourceNo(redSourceNo);
            if (CollUtil.isNotEmpty(apOrderDOS)) {
                ApOrderDO apOrderDO = apOrderDOS.get(0);
                param.setRedSourceNo(apOrderDO.getApOrderNo());
                param.setRedSourceId(apOrderDO.getId());
                apOrderDO.setRedState(true);
                apOrderRepo.saveAndFlush(apOrderDO);
                //  param.setRedState(true);
            }
        }

        //拟定状态
        param.setProposedStatus("DRAFT");


        List<ApOrderDtlSaveParam> apOrderDtlSaveParams = arOrderDtlDTOS.stream().map(
                arOrderDtlDTO -> {
                    ApOrderDtlSaveParam dtlSaveParam = new ApOrderDtlSaveParam();
                    dtlSaveParam.setProtocolCode(arOrderDTO.getProtocolCode());
                    dtlSaveParam.setSourceNo(arOrderDtlDTO.getSourceNo());
                    dtlSaveParam.setSourceLine(arOrderDtlDTO.getSourceLine());
                    dtlSaveParam.setItemId(arOrderDtlDTO.getItemId());
                    dtlSaveParam.setItemCode(arOrderDtlDTO.getItemCode());
                    dtlSaveParam.setItemName(arOrderDtlDTO.getItemName());
                    dtlSaveParam.setItemType(arOrderDtlDTO.getItemType());
                    dtlSaveParam.setSmallCateCode(arOrderDtlDTO.getSmallCateCode());
                    dtlSaveParam.setSmallCateName(arOrderDtlDTO.getSmallCateName());
                    dtlSaveParam.setUom(arOrderDtlDTO.getUom());
                    dtlSaveParam.setUomName(arOrderDtlDTO.getUomName());
                    dtlSaveParam.setQty(arOrderDtlDTO.getQty());
                    dtlSaveParam.setExclTaxPrice(arOrderDtlDTO.getExclTaxPrice());
                    dtlSaveParam.setPrice(arOrderDtlDTO.getPrice());
                    dtlSaveParam.setTaxRate(arOrderDtlDTO.getTaxRate());
                    dtlSaveParam.setTotalAmt(arOrderDtlDTO.getTotalAmt());
                    dtlSaveParam.setTotalCurAmt(arOrderDtlDTO.getTotalCurAmt());
                    dtlSaveParam.setExclTaxAmt(arOrderDtlDTO.getExclTaxAmt());
                    dtlSaveParam.setExclTaxCurAmt(arOrderDtlDTO.getExclTaxCurAmt());
                    dtlSaveParam.setTaxAmt(arOrderDtlDTO.getTaxAmt());
                    dtlSaveParam.setTaxCurAmt(arOrderDtlDTO.getTaxCurAmt());

                    dtlSaveParam.setVerAmt(BigDecimal.ZERO);
                    dtlSaveParam.setUnVerAmt(arOrderDTO.getTotalAmt());
                    dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
                    return dtlSaveParam;
                }
        ).collect(Collectors.toList());
        param.setApOrderDtlSaveParamList(apOrderDtlSaveParams);

        // 按商品编码分组并汇总金额
        Map<String, List<ApOrderDtlSaveParam>> groupedByItemCode = apOrderDtlSaveParams.stream()
                .collect(Collectors.groupingBy(
                        ApOrderDtlSaveParam::getItemCode
                ));
        List<ApOrderDtlGroupSaveParam> orderDtlGroupSaveParams = groupedByItemCode.entrySet().stream().map(
                entry -> {
                    ApOrderDtlGroupSaveParam apOrderDtlGroupSaveParam = new ApOrderDtlGroupSaveParam();
                    apOrderDtlGroupSaveParam.setItemCode(entry.getKey());
                    List<ApOrderDtlSaveParam> value = entry.getValue();
                    ApOrderDtlSaveParam first = value.get(0);
                    apOrderDtlGroupSaveParam.setItemId(first.getItemId());
                    apOrderDtlGroupSaveParam.setItemName(first.getItemName());
                    apOrderDtlGroupSaveParam.setSmallCateCode(first.getSmallCateCode());
                    apOrderDtlGroupSaveParam.setSmallCateName(first.getSmallCateName());

                    apOrderDtlGroupSaveParam.setQty(value.stream().map(ApOrderDtlSaveParam::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setTotalAmt(value.stream().map(ApOrderDtlSaveParam::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setTotalCurAmt(value.stream().map(ApOrderDtlSaveParam::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setExclTaxAmt(value.stream().map(ApOrderDtlSaveParam::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setExclTaxCurAmt(value.stream().map(ApOrderDtlSaveParam::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setTaxAmt(value.stream().map(ApOrderDtlSaveParam::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                    apOrderDtlGroupSaveParam.setTaxCurAmt(value.stream().map(ApOrderDtlSaveParam::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add));

                    return apOrderDtlGroupSaveParam;
                }
        ).collect(Collectors.toList());
        param.setApOrderDtlGroupSaveParamList(orderDtlGroupSaveParams);
        log.info("生成应付单参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }

    private String getCustType2(ArOrderDTO arOrderDTO) {
        List<CrmCustBaseDTO> custBaseInfoList =
                rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(arOrderDTO.getCustCode()));
        if (CollUtil.isEmpty(custBaseInfoList)) {
            throw new com.elitescloud.boot.exception.BusinessException("客户编码" + arOrderDTO.getCustCode() +
                    "对应客户信息不存在");
        }
        CrmCustBaseDTO crmCustBaseDTO = custBaseInfoList.get(0);
        return crmCustBaseDTO.getCustType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(businessId);
        //ArOrderDO newArOrderDO = arOrderRepo.findById(businessId).get();
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
       // ArOrderDTO arOrderDTO = ArOrderConvert.INSTANCE.doConvertToDto(newArOrderDO);

        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(arOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }


    private void updateVerState(Long id){
        //处理核销状态
        ArOrderDTO newArOrderDTO = arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> newArOrderDtlDTOList = arOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newArOrderDtlDTOList)) {
            for (ArOrderDtlDTO arOrderDtlDTO : newArOrderDtlDTOList) {
                if(null != arOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(arOrderDtlDTO.getVerAmt());
                }
                if(arOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(arOrderDtlDTO.getApplyVerAmTing());
                }
                if(arOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(arOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newArOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newArOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newArOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)){
            arOrderRepoProc.updateVerState(verState,id);
        }

    }

}
