package com.elitesland.fin.application.web.expense;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSortParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.service.expense.ExpenseRuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/13 13:23
 * @Description:
 */
@RestController
@RequestMapping("/fin/expense/rule")
@RequiredArgsConstructor
@Api(value = "费用计算规则配置", tags = {"费用计算规则配置"})
public class ExpenseRuleController {
    private final ExpenseRuleConfigService expenseRuleConfigService;

    @PostMapping("/page")
    @ApiOperation("费用计算规则配置-分页查询")
    public ApiResult<PagingVO<ExpRuleConfigPageVO>> page(@RequestBody ExpRuleConfigQueryParam param) {
        val ret = expenseRuleConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/detail/{id}")
    @ApiOperation("费用计算规则配置-详情")
    public ApiResult<ExpRuleConfigQueryVO> detail(@PathVariable("id") Long id) {
        val ret = expenseRuleConfigService.detail(id);
        return ApiResult.ok(ret);
    }

    @PostMapping("/getList/{code}")
    @ApiOperation("费用计算规则配置-获取排序数据")
    public ApiResult<List<ExpRuleConfigQueryVO>> getList(@PathVariable("code") String code) {
        val ret = expenseRuleConfigService.getList(code);
        return ApiResult.ok(ret);
    }

    @PostMapping("/getList/expType")
    @ApiOperation("费用计算规则配置-获取费用类型列表")
    public ApiResult<List<ExpRuleConfigQueryVO>> getExpTypeList() {
        val ret = expenseRuleConfigService.getExpTypeList();
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("费用计算规则配置-保存/更新")
    public ApiResult<Void> save(@RequestBody ExpRuleConfigSaveParam param) {
        expenseRuleConfigService.saveOrUpdate(param);
        return ApiResult.ok();
    }

    @PostMapping("/sort")
    @ApiOperation("费用计算规则配置-排序")
    public ApiResult<Void> sort(@RequestBody List<ExpRuleConfigSortParam> param) {
        expenseRuleConfigService.sort(param);
        return ApiResult.ok();
    }


    @GetMapping("/del/{masId}")
    @ApiOperation("费用计算规则配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        expenseRuleConfigService.del(masId);
        return ApiResult.ok();
    }

    @PostMapping("/enable")
    @ApiOperation("启用/状态批量修改")
    public ApiResult<Void> enable(@RequestBody List<Long> ids) {
        expenseRuleConfigService.updateEnableFlag(ids, true);
        return ApiResult.ok();
    }

    @PostMapping("/stop")
    @ApiOperation("停用/状态批量修改")
    public ApiResult<Void> stop(@RequestBody List<Long> ids) {
        expenseRuleConfigService.updateEnableFlag(ids, false);
        return ApiResult.ok();
    }

}
