package com.elitesland.fin.application.web.writeoff;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 应付付款核销申请.
 *
 * @author shihao.ma
 * @since 2023/8/29
 */
@RestController
@RequestMapping(value = "/fin/ap/ver/apply", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "应付付款核销申请", tags = {"应付付款核销申请"})
@RequiredArgsConstructor
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_AP_PAY_APPLY, businessDoClass = FinApPayVerApplyDO.class)
public class FinApPayVerApplyController {

    private final FinApPayVerApplyService finApPayVerApplyService;

    @PostMapping("/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应付付款核销申请分页(旧)",
            businessObjectType = FinBusinessObjectConstant.FIN_AP_PAY_APPLY,operationCode = FinBusinessObjectConstant.FIN_AP_PAY_APPLY_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<FinApPayVerApplyVO>> page(@RequestBody @Valid FinApPayVerApplyQuery query) {
        return ApiResult.ok(finApPayVerApplyService.page(query));
    }
    @PostMapping("writeOff/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应付付款核销分页（在用）",
            businessObjectType = FinBusinessObjectConstant.FIN_AP_PAY_APPLY,operationCode = FinBusinessObjectConstant.FIN_AP_PAY_APPLY_WRITEOFF_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<FinApPayVerApplyVO>> writeOffPage(@RequestBody @Valid FinApPayVerApplyQuery query) {
        return ApiResult.ok(finApPayVerApplyService.writeOffPage(query));
    }

    @GetMapping("/{id}")
    @ApiOperation(value = "获取明细", notes = "获取明细")
    public ApiResult<FinApPayVerApplyVO> detail(@PathVariable Long id) {
        return ApiResult.ok(finApPayVerApplyService.detail(id));
    }

    @GetMapping("/writeOff/{id}")
    @ApiOperation(value = "获取明细", notes = "获取明细")
    public ApiResult<FinApPayVerApplyVO> writeOffDetail(@PathVariable Long id) {
        return ApiResult.ok(finApPayVerApplyService.writeOffDetail(id));
    }

    @PostMapping("/save")
    @ApiOperation(value = "保存", notes = "保存")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "核销申请保存",allowRepeatRequest = false
    )
    public ApiResult<Long> save(@RequestBody @Valid FinApPayVerApplySaveDTO save) {
        return ApiResult.ok(finApPayVerApplyService.save(save));
    }

    @PostMapping("/submit")
    @ApiOperation(value = "提交", notes = "提交")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "核销申请提交",allowRepeatRequest = false
    )
    public ApiResult<Long> submit(@RequestBody @Valid FinApPayVerApplySaveDTO save) {
        return ApiResult.ok(finApPayVerApplyService.submit(save));
    }

    @PostMapping("/writeOff/submit")
    @ApiOperation(value = "核销", notes = "核销")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单核销申请提交",allowRepeatRequest = false
    )
    public ApiResult<Long> writeOffSubmit(@RequestBody FinApPayVerApplySaveDTO save) {
        save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        final Long id = finApPayVerApplyService.writeOffSubmit(save);
        return ApiResult.ok(id);
    }

    @DeleteMapping()
    @ApiOperation(value = "数据删除", notes = "数据删除")
    public ApiResult<Void> deleteByIds(@RequestBody List<Long> ids) {
        finApPayVerApplyService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批通过", notes = "审批通过")
    @PostMapping("/approve")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "审批通过",allowRepeatRequest = false
    )
    public ApiResult<Void> approve(@RequestBody @Valid FinApPayApplyApprovalDTO dto) {
        finApPayVerApplyService.approve(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批通过", notes = "审批通过")
    @PostMapping("writeOff/approve")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单审批通过",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffApprove(@RequestBody @Valid FinApPayApplyApprovalDTO dto) {
        finApPayVerApplyService.writeOffApprove(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批拒绝", notes = "审批拒绝")
    @PostMapping("/refuse")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "审批拒绝",allowRepeatRequest = false
    )
    public ApiResult<Void> refuse(@RequestBody @Valid FinApPayApplyApprovalDTO dto) {
        finApPayVerApplyService.refuse(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "审批拒绝", notes = "审批拒绝")
    @PostMapping("writeOff/refuse")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单审批拒绝",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffRefuse(@RequestBody @Valid FinApPayApplyApprovalDTO dto) {
        finApPayVerApplyService.writeOffRefuse(dto);
        return ApiResult.ok();
    }

    @ApiOperation(value = "取消核销", notes = "取消核销")
    @PostMapping("/cancel/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "取消核销",allowRepeatRequest = false
    )
    public ApiResult<Void> verCancel(@PathVariable("id") Long id) {
        finApPayVerApplyService.cancel(id);
        return ApiResult.ok();
    }

    @ApiOperation(value = "取消核销", notes = "取消核销")
    @PostMapping("writeOff/cancel/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "整单取消核销",allowRepeatRequest = false
    )
    public ApiResult<Void> writeOffCancel(@PathVariable("id") Long id) {
        finApPayVerApplyService.writeOffCancel(id);
        return ApiResult.ok();
    }

    @ApiOperation(value = "明细拆单详情", notes = "明细拆单详情")
    @GetMapping("/settle/{id}")
    public ApiResult<List<FinApPayVerApplySettleVO>> settleList(@ApiParam("申请单ID") @PathVariable("id") Long id) {
        return ApiResult.ok(finApPayVerApplyService.settleList(id));
    }
    @ApiOperation(value = "测试应付单自动核销", notes = "测试应付单自动核销")
    @PostMapping("writeOff/autoWriteoffAp")
    public ApiResult<Void> autoWriteoffAp(@RequestBody ApOrderDTO apOrderDTO) {
        finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
        return ApiResult.ok();
    }
    @ApiOperation(value = "测试付款单自动核销", notes = "测试付款单自动核销")
    @PostMapping("writeOff/autoWriteoffPay")
    public ApiResult<Void> autoWriteoffPay(@RequestBody PayOrderDTO payOrderDTO) {
        finApPayVerApplyService.autoWriteoffPay(payOrderDTO);
        return ApiResult.ok();
    }
}
