package com.elitesland.fin.common;

import com.elitesland.pur.common.inter.PurInter;
import org.springframework.http.HttpMethod;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/23 周三
 */
public enum FinPushInter implements PurInter {
    BIP_FIN_REC_CREDIT_ACCOUNT_FLOW_SAOBEI_SAVE(FinPushTarget.BIP, FinPushDocType.CREDIT_ACCOUNT_FLOW, "向BIP推送[收款单](扫呗账户流水)", "/nccloud/api/arap/gatheringbill/insertandcommit", HttpMethod.POST),
    BIP_FIN_REC_ACCOUNT_FLOW_STORAGE_SAVE(FinPushTarget.BIP, FinPushDocType.ACCOUNT_FLOW, "向BIP推送[收款单](储值账户流水)", "/nccloud/api/arap/gatheringbill/insertandcommit", HttpMethod.POST),
    BIP_FIN_REC_ADJUST_ORDER_SAVE(FinPushTarget.BIP, FinPushDocType.ADJUST_ORDER, "向BIP推送[收款单](账号调整单)", "/nccloud/api/arap/gatheringbill/insertandcommit", HttpMethod.POST),
    BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE(FinPushTarget.BIP, FinPushDocType.ACCOUNT_FLOW, "向BIP推送[付款单](储值账户流水)", "/nccloud/api/arap/paybill/insertandcommit", HttpMethod.POST),
    ;

    private final FinPushTarget target;
    private final FinPushDocType docType;
    private final String description;
    private final String uri;
    private final HttpMethod uriMethod;

    FinPushInter(FinPushTarget target, FinPushDocType docType, String description, String uri, HttpMethod uriMethod) {
        this.target = target;
        this.docType = docType;
        this.description = description;
        this.uri = uri;
        this.uriMethod = uriMethod;
    }

    public FinPushTarget getTarget() {
        return target;
    }

    public FinPushDocType getDocType() {
        return docType;
    }

    @Override
    public String getTargetSystem() {
        return target.name();
    }

    @Override
    public String getDocTypeCode() {
        return docType.name();
    }

    @Override
    public String getInterCode() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getUri() {
        return uri;
    }

    @Override
    public HttpMethod getUriMethod() {
        return uriMethod;
    }
}
