package com.elitesland.fin.provider.paymentruleconfig;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigConvert;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlNewRpcDTO;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigQueryDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRuleCodeRpcParam;
import com.elitesland.fin.service.paymentruleconfig.PaymentRuleConfigRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.account
 * @date 2023/3/7 14:00
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PaymentRuleConfigRpcService.PATH)
public class PaymentRuleConfigRpcServiceImpl implements PaymentRuleConfigRpcService {


    private final PaymentRuleConfigService paymentRuleConfigService;


    @Override
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> queryAccountAmount(PaymentRuleConfigRpcParam param) {
        log.info("财务账户查询rpc接口，接收到参数：{}", JSON.toJSONString(param));
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = paymentRuleConfigService
                .queryAccountAmount(PaymentRuleConfigConvert.INSTANCE.rpcParam2Param(param));

        return ApiResult.ok(PaymentRuleConfigDtlConvert.INSTANCE.DTO2RpcDTO(paymentRuleConfigDtlDTOList));
    }

    @Override
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> pay(PaymentRuleConfigRpcParam param) {
        log.info("财务支付rpc接口，接收到参数：{}", JSON.toJSONString(param));
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = paymentRuleConfigService.pay(PaymentRuleConfigConvert.INSTANCE.rpcParam2Param(param));
        return ApiResult.ok(PaymentRuleConfigDtlConvert.INSTANCE.DTO2RpcDTO(paymentRuleConfigDtlDTOList));
    }

    @Override
    public ApiResult<Optional<PaymentRuleConfigQueryDTO>> byRuleCode(PaymentRuleConfigRuleCodeRpcParam param) {
        Optional<PaymentRuleConfigQueryVO> paymentRuleConfigQueryVOOptional =
                paymentRuleConfigService.byRuleCode(param.getRuleCode());
        if (paymentRuleConfigQueryVOOptional.isEmpty()) {
            return ApiResult.ok(Optional.empty());
        }
        return ApiResult.ok(Optional.of(PaymentRuleConfigDtlConvert.INSTANCE.VO2RpcDTO(paymentRuleConfigQueryVOOptional.get())));
    }

    @Override
    public ApiResult<List<PaymentRuleConfigDtlNewRpcDTO>> dtlsByRuleCode(PaymentRuleConfigRuleCodeRpcParam param) {
        List<PaymentRuleConfigDtlDTO> list =
                paymentRuleConfigService.dtlsByRuleCode(param.getRuleCode());
        if (CollUtil.isEmpty(list)) {
            return ApiResult.ok(new ArrayList<>());
        }
        return ApiResult.ok(PaymentRuleConfigDtlConvert.INSTANCE.Dtls2RpcDTO(list));
    }
}
