package com.elitesland.fin.provider.spi.impl;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.provider.bip.BipFinService;
import com.elitesland.pur.common.inter.PurRetryProviderSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/9 周三
 */
public class FinPurRetryProviderSPI implements PurRetryProviderSPI {
    private static final Logger logger = LoggerFactory.getLogger(FinPurRetryProviderSPI.class);

    private final Set<String> interCodes = Arrays.stream(FinPushInter.values()).map(FinPushInter::name).collect(Collectors.toSet());

    @Override
    public boolean support(String interCode) {
        return interCodes.contains(interCode);
    }

    @Override
    public ApiResult<String> retryPush(String interCode, Long docId, String docNo) {
        logger.info("财务服务开始重新推送：{}, {}, {}", interCode, docId, docNo);
        switch (FinPushInter.valueOf(interCode)) {
            case BIP_FIN_REC_CREDIT_ACCOUNT_FLOW_SAOBEI_SAVE:
                // 推送扫呗账户流水到BIP
                return SpringContextHolder.getBean(BipFinService.class).pushReceiptOfSaoBeiAccountFlow(docId);
            case BIP_FIN_REC_ACCOUNT_FLOW_STORAGE_SAVE:
                // 推送储值账户流水(收款单)到BIP
                return SpringContextHolder.getBean(BipFinService.class).pushReceiptOfStorageAccountFlow(docId);
            case BIP_FIN_REC_ADJUST_ORDER_SAVE:
                // 推送账号调整单(收款单)到BIP
                return SpringContextHolder.getBean(BipFinService.class).pushReceiptOfAdjustOrder(docId);
            case BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE:
                // 推送储值账户流水(付款单)到BIP
                return SpringContextHolder.getBean(BipFinService.class).pushPaymentOfStorageAccountFlow(docId);
            default:
                throw new RuntimeException("未知的推送接口：" + interCode);
        }
    }
}
