package com.elitesland.fin.application.service.unionpay.entity.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author sunxw
 * @description 饮料支付异步通知resp
 * @Date 2023/5/18
 */
@Data
public class UnionPayAsyncResp {

    /** 版本号 认证支付和快捷支付：20150922 其余：20140728 */
    @JSONField(name = "Version")
    private Integer version;

    /** 0：商户身份接入（默认） 1：机构身份接入 */
    @JSONField(name = "AccessType")
    private Integer accessType;

    /** 机构编号，以机构身份接时必填 */
    @JSONField(name = "InstuId")
    private Long instuId;

    /** 收单机构号 */
    @JSONField(name = "AcqCode")
    private Long acqCode;

    /** 商户号:由 ChinaPay 分配的 15 位长数字，用于确认商户身份 */
    @JSONField(name = "MerId")
    private Long merId;

    /** 商户订单号 */
    @JSONField(name = "MerOrderNo")
    private String merOrderNo;

    /** 商户交易日期 */
    @JSONField(name = "TranDate")
    private Integer tranDate;

    /** 商户交易时间 */
    @JSONField(name = "TranTime")
    private Integer tranTime;

    /** 订单金额 */
    @JSONField(name = "OrderAmt")
    private Long orderAmt;

    /** 交易类型 */
    @JSONField(name = "TranType")
    private Integer tranType;

    /** 业务类型 */
    @JSONField(name = "BusiType")
    private Integer busiType;

    /** 交易币种 */
    @JSONField(name = "CurryNo")
    private String curryNo;

    /** 订单支付状态 */
    @JSONField(name = "OrderStatus")
    private Integer orderStatus;

    /** 签约状态 */
    @JSONField(name = "SignState")
    private Integer signState;

    /** 分账类型 */
    @JSONField(name = "SplitType")
    private Integer splitType;

    /** 分账方式 */
    @JSONField(name = "SplitMethod")
    private Integer splitMethod;

    /** 分账信息 */
    @JSONField(name = "MerSplitMsg")
    private String merSplitMsg;

    /** 收单流水号 */
    @JSONField(name = "AcqSeqId")
    private Long acqSeqId;

    /** 收单日期 */
    @JSONField(name = "AcqDate")
    private Integer acqDate;

    /** 渠道流水号 */
    @JSONField(name = "ChannelSeqId")
    private Integer channelSeqId;

    /** 渠道日期 */
    @JSONField(name = "ChannelDate")
    private Integer channelDate;

    /** 渠道时间 */
    @JSONField(name = "ChannelTime")
    private Integer channelTime;

    /** 支付账单号 */
    @JSONField(name = "PayBillNo")
    private Long payBillNo;

    /** 支付机构号 */
    @JSONField(name = "TransExtField")
    private Integer transExtField;

    /** 商品信息 */
    @JSONField(name = "CommodityMsg")
    private String commodityMsg;

    /** 商户私有域 */
    @JSONField(name = "MerResv")
    private String merResv;

    /** 交易扩展域 */
    @JSONField(name = "TranReserved")
    private String tranReserved;

    /** 有卡交易信息域 */
    @JSONField(name = "CardTranData")
    private Integer cardTranData;

    /** 支付账单号 */
    @JSONField(name = "PayBillNo")
    private Integer PayTimeOut;

    /** 防钓鱼时间戳 */
    @JSONField(name = "TimeStamp")
    private Long timeStamp;

    /** 防钓鱼客户浏览器Ip */
    @JSONField(name = "RemoteAddr")
    private String remoteAddr;

    /** 订单完成日期 */
    @JSONField(name = "CompleteDate")
    private Integer completeDate;

    /** 订单完成时间 */
    @JSONField(name = "CompleteTime")
    private Integer completeTime;

    /** 签名 */
    @JSONField(name = "Signature")
    private String signature;


}
