/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.adjustorder;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.entity.adjustorder.QAdjustOrderDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AdjustOrderRepoProc
extends BaseRepoProc<AdjustOrderDO> {
    private static final QAdjustOrderDO adjustOrder = QAdjustOrderDO.adjustOrderDO;

    public AdjustOrderRepoProc() {
        super((EntityPathBase)adjustOrder);
    }

    public PagingVO<AdjustOrderVO> page(AdjustOrderPageParam adjustOrderPageParam) {
        List<Predicate> where = this.where(adjustOrderPageParam);
        JPAQuery query = (JPAQuery)this.select(AdjustOrderVO.class).where(ExpressionUtils.allOf(where));
        BusinessSecurityUtil.where(query, AdjustOrderDO.class);
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, adjustOrder);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<AdjustOrderVO> queryByIds(List<Long> id) {
        return ((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)AdjustOrderRepoProc.adjustOrder.id.in(id))).fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        this.jpaQueryFactory.update((EntityPath)adjustOrder).set((Path)AdjustOrderRepoProc.adjustOrder.state, (Object)status).set(AdjustOrderRepoProc.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)AdjustOrderRepoProc.adjustOrder.auditUser, (Object)sysUserDTO.getLastName()).set(AdjustOrderRepoProc.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).where(new Predicate[]{AdjustOrderRepoProc.adjustOrder.id.in(ids)}).execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)adjustOrder).set((Path)AdjustOrderRepoProc.adjustOrder.state, (Object)status).set(AdjustOrderRepoProc.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)AdjustOrderRepoProc.adjustOrder.auditUser, (Object)sysUserDTO.getLastName()).set(AdjustOrderRepoProc.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).set((Path)AdjustOrderRepoProc.adjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{AdjustOrderRepoProc.adjustOrder.id.in(ids)}).execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)adjustOrder).set((Path)AdjustOrderRepoProc.adjustOrder.state, (Object)status).set(AdjustOrderRepoProc.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)AdjustOrderRepoProc.adjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set(AdjustOrderRepoProc.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).set((Path)AdjustOrderRepoProc.adjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{AdjustOrderRepoProc.adjustOrder.id.in(ids)}).execute();
    }

    public AdjustOrderVO queryById(Long id) {
        return (AdjustOrderVO)((Object)((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)AdjustOrderRepoProc.adjustOrder.id.eq((Object)id))).fetchOne());
    }

    private List<Predicate> where(AdjustOrderPageParam adjustOrderPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getIds())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.id.in(adjustOrderPageParam.getIds()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getState())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.state.in(adjustOrderPageParam.getState()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjType())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.adjType.in(adjustOrderPageParam.getAdjType()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjReason())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.adjReason.in(adjustOrderPageParam.getAdjReason()));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getDocNo())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.docNo.like("%" + adjustOrderPageParam.getDocNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getDocNoList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.docNo.in(adjustOrderPageParam.getDocNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getAccName())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accName.eq((Object)adjustOrderPageParam.getAccName()));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getAccNameList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accName.in(adjustOrderPageParam.getAccNameList()));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getAccCode())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accCode.eq((Object)adjustOrderPageParam.getAccCode()));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getAccCodeList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accCode.in(adjustOrderPageParam.getAccCodeList()));
        }
        if (adjustOrderPageParam.getAuditTimeS() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.auditTime.goe((Comparable)adjustOrderPageParam.getAuditTimeS()));
        }
        if (adjustOrderPageParam.getAuditTimeE() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.auditTime.loe((Comparable)adjustOrderPageParam.getAuditTimeE()));
        }
        if (adjustOrderPageParam.getTotalAmtF() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.totalAmt.goe((Number)adjustOrderPageParam.getTotalAmtF()));
        }
        if (adjustOrderPageParam.getTotalAmtT() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.totalAmt.loe((Number)adjustOrderPageParam.getTotalAmtT()));
        }
        if (adjustOrderPageParam.getCreateTimeS() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.createTime.goe((Comparable)adjustOrderPageParam.getCreateTimeS()));
        }
        if (adjustOrderPageParam.getCreateTimeE() != null) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.createTime.loe((Comparable)adjustOrderPageParam.getCreateTimeE()));
        }
        if (StrUtil.isNotBlank((CharSequence)adjustOrderPageParam.getType())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.type.eq((Object)adjustOrderPageParam.getType()));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getTypeList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.type.in(adjustOrderPageParam.getTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)adjustOrderPageParam.getAccountHolderName())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accountHolderName.like("%" + adjustOrderPageParam.getAccountHolderName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getAccountHolderNameList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accountHolderName.in(adjustOrderPageParam.getAccountHolderNameList()));
        }
        if (CollectionUtils.isNotEmpty(adjustOrderPageParam.getAccountHolderCodeList())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.accountHolderCode.in(adjustOrderPageParam.getAccountHolderCodeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)adjustOrderPageParam.getRemark())) {
            predicates.add((Predicate)AdjustOrderRepoProc.adjustOrder.remark.like("%" + adjustOrderPageParam.getRemark() + "%"));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)adjustOrderPageParam.getConditions(), AdjustOrderDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AdjustOrderRepoProc.adjustOrder.id, AdjustOrderRepoProc.adjustOrder.state, AdjustOrderRepoProc.adjustOrder.type, AdjustOrderRepoProc.adjustOrder.accCode, AdjustOrderRepoProc.adjustOrder.accName, AdjustOrderRepoProc.adjustOrder.accType, AdjustOrderRepoProc.adjustOrder.auditTime, AdjustOrderRepoProc.adjustOrder.auditRejectReason, AdjustOrderRepoProc.adjustOrder.auditUser, AdjustOrderRepoProc.adjustOrder.recAccTime, AdjustOrderRepoProc.adjustOrder.docNo, AdjustOrderRepoProc.adjustOrder.createTime, AdjustOrderRepoProc.adjustOrder.creator, AdjustOrderRepoProc.adjustOrder.totalAmt, AdjustOrderRepoProc.adjustOrder.remark, AdjustOrderRepoProc.adjustOrder.ouId, AdjustOrderRepoProc.adjustOrder.ouCode, AdjustOrderRepoProc.adjustOrder.ouName, AdjustOrderRepoProc.adjustOrder.modifyTime, AdjustOrderRepoProc.adjustOrder.modifyUserId, AdjustOrderRepoProc.adjustOrder.updater, AdjustOrderRepoProc.adjustOrder.adjReason, AdjustOrderRepoProc.adjustOrder.adjType, AdjustOrderRepoProc.adjustOrder.accountHolderName, AdjustOrderRepoProc.adjustOrder.accountHolderCode, AdjustOrderRepoProc.adjustOrder.workflowProcInstId.as("procInstId"), AdjustOrderRepoProc.adjustOrder.workflowProcInstStatus.as("procInstStatus"), AdjustOrderRepoProc.adjustOrder.extensionInfo, AdjustOrderRepoProc.adjustOrder.storedBankAcc})).from((EntityPath)adjustOrder);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAdjustOrder(AdjustOrderDO adjustOrderDO, ProcessInfo processInfo) {
        QAdjustOrderDO qAdjustOrderDO = QAdjustOrderDO.adjustOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qAdjustOrderDO).set((Path)qAdjustOrderDO.workflowProcInstId, (Object)processInfo.getProcInstId()).set(qAdjustOrderDO.workflowSubmitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qAdjustOrderDO.id.eq((Object)adjustOrderDO.getId())});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qAdjustOrderDO.workflowProcInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)qAdjustOrderDO.state, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        jpaUpdateClause.execute();
    }
}

