package com.elitesland.fin.application.facade.vo.creditaccount;


import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */

@Data
@ApiModel(description = "账户事务码")
public class CreditAccountIocSaveVO extends BaseModelParam implements Serializable {
    private static final long serialVersionUID = -6084527411643768273L;

    @ApiModelProperty("事务码")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    private String ioName;

    @ApiModelProperty("事务类型 [UDC]FIN:CREDIT_IO_TYPE")
    private String ioType;

    @ApiModelProperty("事务类型名称")
    private String ioTypeName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

}
