package com.elitesland.fin.application.service.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderParam;
import com.elitesland.fin.application.facade.param.flow.*;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;

import java.util.List;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
public interface AccountFlowService {


    /**
     * 账户流水分页查询：中台端
     *
     * @param pageParam 入参
     * @return 账户流水信息集合
     */
    PagingVO<AccountFlowVO> page(AccountFlowPageParam pageParam);

    /**
     * 账户流水分页查询：APP端
     *
     * @param pageParam 入参
     * @return 账户流水信息集合
     */
    PagingVO<AccountFlowVO> appPage(AccountFlowPageParam pageParam);

    /**
     * 账户流水分页查询：APP端
     *
     * @param pageParam 入参
     * @return 账户流水信息聚合
     */
    List<AccountFlowVO> appList(AccountFlowPageParam pageParam);


    /**
     * 根据数据来源+来源单号查询流水的信息
     * <p>
     * 使用场景1：校验是否有重复数据已经存在
     *
     * @param dataSource 数据来源
     * @param sourceNo   来源单号
     * @return 账户流水信息
     */
    List<AccountFlowVO> selectBySourceAndNo(String dataSource, String sourceNo);

    /**
     * 账户流水保存
     *
     * @param paramList 入参
     * @return 账户流水返回对象
     */
    AccountFlowVO save(List<AccountFlowParam> paramList);

    /**
     * 账户流水保存
     *
     * @param param 入参
     * @return 账户流水返回对象
     */
    AccountFlowDO saveAccountFlow(AccountFlowParam param);


    void fixAccountFlow(List<AccountFlowFixParam> paramList);

    /**
     * 校验必填项
     *
     * @param paramList 入参
     */
    void checkMandatoryFieldList(List<AccountFlowParam> paramList);

    /**
     * 校验必填项
     *
     * @param param 入参
     */
    void checkMandatoryField(AccountFlowParam param);

    /**
     * 校验是否有重复数据或脏数据、数据结构是否正确：
     * 必须每次只有一种数据来源，要不数据融合在一起无法判断谁先谁后，会涉及到上一条数据问题。
     * 同种数据来源，也应该是单次的（一个单号），就是不是批量的，会涉及到上一条数据问题。
     * 可以先判断数据来源是否是多种，再判断账户类型+数据来源+交易类型是否是唯一
     *
     * @param paramList 入参
     */
    void checkRepeatability(List<AccountFlowParam> paramList);

    /**
     * 校验必填项02:年月日期、账户编码
     *
     * @param pageParam 查询入参
     */
    void checkMandatoryField02(AccountFlowPageParam pageParam);

    /**
     * 经销商端账户流水分页查询：
     *
     * @param pageParam 入参
     * @return 账户流水信息集合
     */
    PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam pageParam);

    /**
     * 经销商端查询相关统计金额：入账金额、使用金额
     *
     * @param pageParam 入参
     * @return 相关统计金额出参对象
     */
    AccountFlowDealerVO dealerSelectAmt(AccountFlowPageParam pageParam);

    /**
     * 经销商端查询相关统计金额：储值账户金额、返利账户金额
     *
     * @param param 入参
     * @return 相关统计金额出参对象
     */
    AccountFlowDealerVO dealerSelectAccAmt(AccountFlowDealerParam param);

    /**
     * 流水审批通过
     */
    void approve(AccountFlowParam accountFlowParam);

    /**
     * 流水审批拒绝
     */
    void reject(AccountFlowParam accountFlowParam);

    /**
     * 查询流水信息
     */
    List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam);

    /**
     * 账户流水回调
     */
    void accountFlowCallBack(String doc, AccountFlowDO accountFlowDO, boolean isApprove);

    /**
     * 生成账户流水
     */
    String generateAccountFlow(AccountFlowParam accountFlowParam);

    /**
     * 校验账户余额
     */
    Boolean checkAccountBalance(AccountFlowParam accountFlowParam);


    List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam);

    List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam pageParam);

    List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam pageParam);

    /**
     * 流水自动审批
     * @param accountFlowParam
     */
    public void autoApprove(AccountFlowParam accountFlowParam);

    /**
     * 自动审批类流水生成
     * @param accountFlowParamList
     */
   void updateAccountBalanceAndGenerateAccountFlow(List<AccountFlowParam> accountFlowParamList);

   AccountFlowDO saveAccountFlowWithOutTx(AccountFlowParam accountFlowParam);
    public void saveAccountFlowList(List<AccountFlowParam> accountFlowParams);

    /**
     * 删除账户流水
     */
    void updateDeleteFlagBatch(List<Long> ids);
}
