package com.elitesland.fin.domain.service.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
public interface ReceiptPaymentAgreementDtlDomainService {

    /**
     * 收付款协议明细保存
     *
     * @param saveParamList 入参
     * @return 收付款协议明细明细ID
     */
    List<Long> saveDtl(List<ReceiptPaymentAgreementDtlSaveParam> saveParamList);

    /**
     * 根据主表ID删除收付款协议明细
     *
     * @param masId 主表ID
     * @return
     */
    void deleteByMasId(Long masId);


    /**
     * 根据主表ID查询收付款协议明细
     *
     * @param masId 主表ID
     * @return 收付款协议明细
     */
    List<ReceiptPaymentAgreementDtlVO> selectByMasId(Long masId);

    /**
     * 根据入参查询收付款协议明细
     *
     * @param queryVO 入参
     * @return 收付款协议明细
     */
    List<ReceiptPaymentAgreementDtlVO> selectByParam(ReceiptPaymentAgreementDtlPageParam queryVO);


    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds);
}
