package com.elitesland.fin.infr.repo.apverconfig;

import com.elitesland.fin.domain.entity.apverconfig.QApVerConfigDO;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/6 15:25
 */
@Component
@RequiredArgsConstructor
public class ApVerConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QApVerConfigDO qApVerConfigDO = QApVerConfigDO.apVerConfigDO;

    public ApVerConfigDTO queryById(Long id) {
        return select(ApVerConfigDTO.class)
                .where(qApVerConfigDO.id.eq(id))
                .fetchOne();
    }

    public List<ApVerConfigDTO> queryByIds(List<Long> ids) {
        return select(ApVerConfigDTO.class)
                .where(qApVerConfigDO.id.in(ids))
                .fetch();
    }

    public List<ApVerConfigDTO> queryAll() {
        return select(ApVerConfigDTO.class)
                .where(qApVerConfigDO.enableFlag.isTrue())
                .fetch();
    }

    public ApVerConfigDTO queryDef() {
        return select(ApVerConfigDTO.class)
                .where(qApVerConfigDO.enableFlag.isTrue())
                .where(qApVerConfigDO.defaultFlag.isTrue())
                .where(qApVerConfigDO.deleteFlag.eq(0))
                .fetchOne();
    }

    public Boolean existNameByName(String name) {
        return jpaQueryFactory.select(qApVerConfigDO.id)
                .from(qApVerConfigDO)
                .where(qApVerConfigDO.schemeName.eq(name))
                .fetchCount() > 0;
    }

    public Boolean existNameById(String name, Long id) {
        return jpaQueryFactory.select(qApVerConfigDO.id)
                .from(qApVerConfigDO)
                .where(qApVerConfigDO.schemeName.eq(name))
                .where(qApVerConfigDO.id.notIn(id))
                .fetchCount() > 0;
    }


    public Long updateDefaultById(Long id, Boolean isDefault) {
        return jpaQueryFactory.update(qApVerConfigDO)
                .set(qApVerConfigDO.defaultFlag, isDefault)
                .where(qApVerConfigDO.id.eq(id))
                .execute();
    }

    public void updateDefault() {
        jpaQueryFactory.update(qApVerConfigDO)
                .set(qApVerConfigDO.defaultFlag, false)
                .where(qApVerConfigDO.defaultFlag.isTrue())
                .execute();
    }

    public void updateEnable(List<Long> ids) {
        jpaQueryFactory.update(qApVerConfigDO)
                .set(qApVerConfigDO.enableFlag, false)
                .where(qApVerConfigDO.id.in(ids))
                .execute();
    }

    public PagingVO<ApVerConfigDTO> page(ApVerConfigPageParam param) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();

        predicates.add(qApVerConfigDO.deleteFlag.eq(0));
        JPAQuery<ApVerConfigDTO> query = select(ApVerConfigDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qApVerConfigDO);
        return PagingVO.<ApVerConfigDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public Boolean isFirst() {
        return jpaQueryFactory.select(qApVerConfigDO.id)
                .from(qApVerConfigDO)
                .where(qApVerConfigDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApVerConfigDO.id,
                qApVerConfigDO.enableFlag,
                qApVerConfigDO.schemeName,
                qApVerConfigDO.schemeNo,
                qApVerConfigDO.defaultFlag,
                qApVerConfigDO.remark,
                qApVerConfigDO.createTime,
                qApVerConfigDO.creator,
                qApVerConfigDO.createUserId,
                qApVerConfigDO.modifyTime,
                qApVerConfigDO.modifyUserId,
                qApVerConfigDO.updater,
                qApVerConfigDO.writeoffOrder,
                qApVerConfigDO.redOffsetFlag)
        ).from(qApVerConfigDO);
    }
}
