package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "值集")
public class FinFlexibleParam extends BaseModelParam {

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("值集名称")
    private String flexibleName;

    @ApiModelProperty("值集类型，0：主值集，1：从属值集")
    private String flexibleType;

    @ApiModelProperty("主值集编码")
    private String parentFlexibleCode;

    @ApiModelProperty("主值集名称")
    private String parentFlexibleName;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("值集明细")
    private List<FinFlexibleValueParam> detailList;

    @ApiModelProperty("是否有子代")
    private Boolean descendantsFlag;
}
