package com.elitesland.fin.infr.repo.recorder;

import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;

import java.math.BigDecimal;
import java.util.List;

import feign.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:40
 */
@Repository
public interface RecOrderDtlRepo extends JpaRepository<RecOrderDtlDO, Long>, QuerydslPredicateExecutor<RecOrderDtlDO> {

    List<RecOrderDtlDO> findAllByMasId(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update rec_order_dtl set modify_time = CURRENT_TIMESTAMP, " +
            " audit_data_version = :version + 1, ver_amt = :verAmt, ver_amting = :verAmting, un_ver_amt = :unVerAmt where id =:recOrderDtlId and " +
            " audit_data_version = :version and delete_flag != 1", nativeQuery = true)
    int updateExtVerAmt(@Param("recOrderDtlId") Long recOrderDtlId, @Param("version") Integer version
            , @Param("verAmt") BigDecimal verAmt, @Param("verAmting") BigDecimal verAmting, @Param("unVerAmt") BigDecimal unVerAmt);
}
