package com.elitesland.fin.application.facade.dto.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetConditionParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎明细")
public class FinAccountEngineDetailsDTO extends BaseModelDTO {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("会计引擎名称")
    private String accountEngine;

    @ApiModelProperty("是否启用")
    private Boolean activeFlag;

    @ApiModelProperty("会计引擎条件")
    private List<FinAccEngDetConditionDTO> finAccEngDetConditionDetailList;

    @ApiModelProperty("数据行详情")
    private List<FinAccEngDetDataDTO> finAccEngDetDataDetailList;

    @ApiModelProperty("拟定类型")
    private String proposedType;
}
