package com.elitesland.fin.application.web.aporder;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlGroupVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.service.aporder.ApOrderDtlGroupService;
import com.elitesland.fin.application.service.aporder.ApOrderDtlService;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlGroupPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author Karl.wang
 * @version V1.0
 * @Package com.elitesland.fin.application.web.aporder
 * @date 2022/3/16 16:08
 */
@RestController
@RequestMapping("/fin/apOrder")
@RequiredArgsConstructor
@Api(value = "应付单", tags = {"应付单"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_AP_ORDER, businessDoClass = ApOrderDO.class)
public class ApOrderController {

    private final ApOrderService apOrderService;
    private final ApOrderDtlService apOrderDtlService;
    private final ApOrderDtlGroupService apOrderDtlGroupService;



    @PostMapping("save")
    @ApiOperation("新增-应付单")
    public ApiResult<Long> save(@RequestBody ApOrderSaveParam apOrderSaveParam) {
        ApiResult<Long> res = apOrderService.save(apOrderSaveParam);
        return res;
    }

    @PostMapping("update")
    @ApiOperation("修改-应付单")
    public ApiResult<Long> update(@RequestBody ApOrderSaveParam apOrderSaveParam) {
        ApiResult<Long> res = apOrderService.update(apOrderSaveParam);
        return res;
    }

    @PostMapping("commit")
    @ApiOperation("提交-应付单")
    public ApiResult<Long> commit(@RequestBody ApOrderSaveParam apOrderSaveParam) {
        ApiResult<Long> res = apOrderService.commit(apOrderSaveParam);
        return res;
    }

    @PostMapping("page")
    @ApiOperation("应付单列表查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应付单分页",
            businessObjectType = FinBusinessObjectConstant.FIN_AP_ORDER,operationCode = FinBusinessObjectConstant.FIN_AP_ORDER_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<ApOrderVO>> page(@RequestBody ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderVO> res = apOrderService.page(apOrderPageParam);
        return ApiResult.ok(res);
    }

    @GetMapping("get")
    @ApiOperation("获取单个应付单详情")
    public ApiResult<ApOrderVO> get(Long id) {
        ApOrderVO res = apOrderService.get(id);
        return ApiResult.ok(res);
    }

    @GetMapping("getForDtl")
    @ApiOperation("获取应付单详情和明细信息汇总信息")
    public ApiResult<ApOrderVO> getForDtl(Long id) {
        ApOrderVO res = apOrderService.getApOrderAndDtl(id);
        return ApiResult.ok(res);
    }

    @PostMapping("dtlPage")
    @ApiOperation("分页查询明细信息")
    public ApiResult<PagingVO<ApOrderDtlVO>> detailPage(@RequestBody ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlVO> res = apOrderDtlService.page(apOrderDtlPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("grpPage")
    @ApiOperation("分页查询汇总信息")
    public ApiResult<PagingVO<ApOrderDtlGroupVO>> grpPage(@RequestBody ApOrderDtlGroupPageParam apOrderDtlGroupPageParam) {
        PagingVO<ApOrderDtlGroupVO> res = apOrderDtlGroupService.page(apOrderDtlGroupPageParam);
        return ApiResult.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除应付单")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        ApiResult<Long> res = apOrderService.del(ids);
        return res;
    }

    @GetMapping("/export")
    @ApiOperation("分页查询导出数据,导出条数为分页参数设置,可设置默认5000条")
    public void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam) {
        apOrderService.exportExl(response, apOrderPageParam);
    }

    @PostMapping("/red/punch/{id}")
    @ApiOperation("红冲-redPunch")
    public ApiResult<Long> redPunch(@PathVariable Long id) {
        return apOrderService.redPunch(id);
    }

    @PostMapping("/cancel")
    @ApiOperation("取消-应付单")
    public ApiResult<Void> cancel(@RequestBody List<Long> ids) {
        return apOrderService.cancelApprove(ids);
    }
    @PostMapping("writeoff/page")
    @ApiOperation("应付单待核销列表查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "应付单待核销分页",
            businessObjectType = FinBusinessObjectConstant.FIN_AP_ORDER,operationCode = FinBusinessObjectConstant.FIN_AP_ORDER_WRITE_OFF_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<ApOrderVO>> extpage(@RequestBody ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderVO> res = apOrderService.writeoffPage(apOrderPageParam);
        return ApiResult.ok(res);
    }
}
