package com.elitesland.fin.provider.invoice.await;

import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.enums.InvoiceAwaitTypeEnum;
import com.elitesland.fin.param.invoice.InvoiceAwaitDSaveParam;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.rpc.system.SystemRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 订货单创建付款记录类
 * Created by lance on 2023/7/13.
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SalSoInvoiceAwaitSaveServiceImpl implements InvoiceAwaitSaveService {

    private final InvoiceAwaitRepo invoiceAwaitRepo;

    private final InvoiceAwaitDRepo invoiceAwaitDRepo;

    private final SystemRpcService systemRpcService;

    @Override
    public InvoiceAwaitTypeEnum getPaymentRecordStrategy() {
        return InvoiceAwaitTypeEnum.SAL_SO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {
        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        // 通过发号器设置付款记录编号
        invoiceAwaitDO.setDocNo(systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<>()));
        // 来源单据：收货单
        Long masId = invoiceAwaitRepo.save(invoiceAwaitDO).getId();
        this.saveRecordsD(param, masId);
        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List<InvoiceAwaitDSaveParam> invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();

        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        // 删除旧的明细
        invoiceAwaitDRepo.deleteByMasId(masId);
        invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }
}
