package com.elitesland.fin.repo.invoice;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/06/02
 */
@Component
@RequiredArgsConstructor
public class InvoiceApplyRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;
    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;

    public List<InvoiceApplyRpcDTO> queryIdBySource(InvoiceQueryParam param) {
        List<Predicate> predicates = new ArrayList<>();
        // 来源单据ID
        if (CollUtil.isNotEmpty(param.getSourceDocId())) {
            predicates.add(qSaleInvDtlDO.sourceId.in(param.getSourceDocId()));
        }
        // 来源单据编码
        if (CollUtil.isNotEmpty(param.getSourceDocNo())) {
            predicates.add(qSaleInvDtlDO.sourceNo.in(param.getSourceDocNo()));
        }
        return jpaQueryFactory.select(Projections.bean(InvoiceApplyRpcDTO.class,
                        qSaleInvDO.id.as("applyId"),
                        qSaleInvDO.applyNo))
                .from(qSaleInvDO)
                .leftJoin(qSaleInvDtlDO).on(qSaleInvDtlDO.masId.eq(qSaleInvDO.id))
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }
}
