/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.writeoff.RmiUdcService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServiceImpl.class);
    private final InvoiceApplyService invoiceApplyService;
    private final InvoiceSaveService invoiceSaveService;
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceDtlDomainService invoiceDtlDomainService;
    private final SaleInvDtlRepo tsSaleInvDtlRepo;
    private final ItmItemRpcService itmItemRpcService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    @Autowired
    private RmiUdcService rmiSysUdcRpcService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;

    @Override
    public long create(InvoiceApplyParam param) {
        this.checeInvParam(param);
        InvoiceQueryParam queryParam = new InvoiceQueryParam();
        queryParam.setSourceDocId(param.getIds());
        List<InvoiceApplyRpcDTO> applyRpcDTO = this.invoiceApplyService.queryIdBySource(queryParam);
        if (CollUtil.isNotEmpty(applyRpcDTO)) {
            throw new BusinessException("\u5355\u636e\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
        }
        List<InvoiceSaveVO> save = this.invoiceSaveService.save(param);
        if (!CollUtil.isEmpty(save)) {
            return save.get(0).getApplyId();
        }
        return 0L;
    }

    @Override
    @Transactional
    public Long redraft(String applyNo) {
        InvoiceRedraftDO invRedraftDO = this.invoiceRedraftRepo.findByOrigApplyNo(applyNo);
        if (!ObjectUtils.isEmpty((Object)((Object)invRedraftDO)) && !ObjectUtils.isEmpty((Object)invRedraftDO.getWorkflowProcInstStatus())) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u91cd\u65b0\u5f00\u7968\u5ba1\u6279");
        }
        InvoiceApplyRpcDTO applyRpcDTO = this.invoiceApplyService.queryIdByApplyNo(applyNo);
        Assert.notNull((Object)applyRpcDTO.getApplyId(), (String)(applyNo + " \u5355\u636e\u4e0d\u5b58\u5728"));
        InvoiceRedraftDO invoiceRedraftDO = this.saveInvoiceRedraft(applyRpcDTO);
        return invoiceRedraftDO.getId();
    }

    @Override
    public void rePush(ApplyRePushParam param) {
        List<SaleInvDO> applyList = this.saleInvRepo.findByApplyNoIn(param.getApplyNoList());
        if (CollectionUtils.isEmpty(applyList)) {
            throw new BusinessException("\u672a\u627e\u5230\u5355\u636e");
        }
        applyList.forEach(apply -> {
            InvoiceApplySaveParam invoiceApplySaveParam = new InvoiceApplySaveParam();
            BeanUtils.copyProperties((Object)apply, (Object)invoiceApplySaveParam);
            List<SaleInvDtlDO> allByMasIdIn = this.tsSaleInvDtlRepo.findAllByMasIdIn((Collection<Long>)new ArrayList<Long>(){
                {
                    this.add(apply.getId());
                }
            });
            ArrayList<InvoiceDetailSaveParam> detail = new ArrayList<InvoiceDetailSaveParam>();
            allByMasIdIn.forEach(v -> {
                InvoiceDetailSaveParam invoiceDetailSaveParam = new InvoiceDetailSaveParam();
                BeanUtils.copyProperties((Object)v, (Object)invoiceDetailSaveParam);
                invoiceDetailSaveParam.setLineNo(v.getSourceLine());
                detail.add(invoiceDetailSaveParam);
            });
            invoiceApplySaveParam.setDetails(detail);
            this.abstractInvoiceSaveService.aisinoBlueInvoiceApply(invoiceApplySaveParam, apply.getApplyNo());
        });
    }

    @Override
    public void getBlueResult(List<Long> saleInvIdList) {
        List allById = this.saleInvdDtlRepo.findAllById(saleInvIdList);
        for (SaleInvdDtlDO saleInvdDtlDO : allById) {
            this.abstractInvoiceSaveService.getInvoiceInfoByFlowNo(saleInvdDtlDO);
            this.abstractInvoiceSaveService.getBlueResult(saleInvdDtlDO);
        }
        this.saleInvdDtlRepo.saveAll(allById);
    }

    @Override
    public List<SaleInvDtlVO> getDtlList(Long masId) {
        try {
            List<SaleInvDtlDTO> list = this.invoiceDtlDomainService.getList(masId);
            Set itemCodeList = list.stream().map(SaleInvDtlDTO::getItemCode).collect(Collectors.toSet());
            Set itemIdList = list.stream().map(SaleInvDtlDTO::getItemId).collect(Collectors.toSet());
            ItmItemRpcDtoParam itmItemParam = new ItmItemRpcDtoParam();
            itmItemParam.setItemCodes(new ArrayList(itemCodeList));
            itmItemParam.setItemIds(new ArrayList(itemIdList));
            List itmItemResps = this.itmItemRpcService.findItemRpcDtoByParam(itmItemParam);
            Map<String, String> itemCodeAndNameMap = itmItemResps.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemName));
            Map<String, String> itemNameAndCodeMap = itemCodeAndNameMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map udcValues = (Map)org.apache.commons.lang3.ObjectUtils.defaultIfNull(this.rmiSysUdcRpcService.getUdcMapByUdcCode("yst-supp", "TAXONOMY_CODE"), new HashMap());
            list = list.stream().peek(v -> {
                String taxName = udcValues.getOrDefault(v.getTaxCode(), "");
                v.setTaxName(taxName);
                if (!ObjectUtils.isEmpty((Object)v.getItemCode()) && ObjectUtils.isEmpty((Object)v.getItemName())) {
                    String itemName = itemCodeAndNameMap.getOrDefault(v.getItemCode(), v.getItemName());
                    v.setItemName(itemName);
                } else if (!ObjectUtils.isEmpty((Object)v.getItemName()) && ObjectUtils.isEmpty((Object)v.getItemCode())) {
                    String itemCode = itemNameAndCodeMap.getOrDefault(v.getItemName(), v.getItemCode());
                    v.setItemCode(itemCode);
                }
            }).collect(Collectors.toList());
            List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
            return res;
        }
        catch (Exception e) {
            log.error("Fetching sale details failed" + e.getMessage(), (Throwable)e);
            throw new BusinessException("Fetching sale details failed", (Throwable)e);
        }
    }

    private InvoiceRedraftDO saveInvoiceRedraft(InvoiceApplyRpcDTO applyRpcDTO) {
        SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(applyRpcDTO.getApplyNo());
        List<SaleInvdDtlVO> saleInvdDtlVOs = this.saleInvService.getInvdLists(saleInvDO.getId());
        if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
            SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
            InvoiceRedraftDO invoiceRedraftDO = new InvoiceRedraftDO();
            invoiceRedraftDO.setOrigApplyNo(applyRpcDTO.getApplyNo());
            invoiceRedraftDO.setInvoiceNo(saleInvdDtlVO.getInvNo());
            invoiceRedraftDO.setSerialNo(saleInvdDtlVO.getFlowNo());
            invoiceRedraftDO.setInvoiceAmt(saleInvdDtlVO.getTotalAmt());
            invoiceRedraftDO.setInvoiceDate(saleInvdDtlVO.getInvDate());
            invoiceRedraftDO.setInvoiceType(saleInvDO.getInvType());
            invoiceRedraftDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);
            invoiceRedraftDO.setCustCode(saleInvDO.getCustCode());
            this.invoiceRedraftRepo.save((Object)invoiceRedraftDO);
            return invoiceRedraftDO;
        }
        throw new BusinessException("\u5f53\u524d\u9500\u552e\u53d1\u7968\u65e0\u5f00\u7968\u660e\u7ec6" + applyRpcDTO.getApplyId());
    }

    public void checeInvParam(InvoiceApplyParam param) {
        Assert.notNull((Object)param.getInvType(), (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)param.getCustInvTitle(), (String)"\u5f00\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)param.getCustTaxNo(), (String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public InvoiceServiceImpl(InvoiceApplyService invoiceApplyService, InvoiceSaveService invoiceSaveService, InvoiceRedraftRepo invoiceRedraftRepo, SaleInvRepo saleInvRepo, SaleInvService saleInvService, InvoiceDtlDomainService invoiceDtlDomainService, SaleInvDtlRepo tsSaleInvDtlRepo, ItmItemRpcService itmItemRpcService, SaleInvdDtlRepo saleInvdDtlRepo) {
        this.invoiceApplyService = invoiceApplyService;
        this.invoiceSaveService = invoiceSaveService;
        this.invoiceRedraftRepo = invoiceRedraftRepo;
        this.saleInvRepo = saleInvRepo;
        this.saleInvService = saleInvService;
        this.invoiceDtlDomainService = invoiceDtlDomainService;
        this.tsSaleInvDtlRepo = tsSaleInvDtlRepo;
        this.itmItemRpcService = itmItemRpcService;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
    }
}

