/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookOuConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookOuDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookParam;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSetOfBookDO;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinSetOfBookRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final QFinSetOfBookDO qFinSetOfBookDO = QFinSetOfBookDO.finSetOfBookDO;

    public PagingVO<FinSetOfBookDTO> page(FinSetOfBookParam finSetOfBookParam) {
        Predicate where = this.where(finSetOfBookParam);
        JPAQuery query = (JPAQuery)this.select(FinSetOfBookDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        finSetOfBookParam.fillOrders(query, this.qFinSetOfBookDO);
        finSetOfBookParam.setPaging(query);
        List finSetOfBookDTOList = query.fetch();
        List<Long> ids = finSetOfBookDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = FinSetOfBookLineConvert.INSTANCE.DOToDTO(this.finSetOfBookLineRepo.findAllByMasIdIn(ids));
        List<FinSetOfBookOuDTO> finSetOfBookOuDTOList = FinSetOfBookOuConvert.INSTANCE.DOToDTO(this.finSetOfBookOuRepo.findAllByMasIdIn(ids));
        for (FinSetOfBookDTO finSetOfBookDTO : finSetOfBookDTOList) {
            finSetOfBookDTO.setDimenDetailList(finSetOfBookLineDTOList.stream().filter(finSetOfBookLineDTO -> finSetOfBookDTO.getId().equals(finSetOfBookLineDTO.getMasId())).collect(Collectors.toList()));
            finSetOfBookDTO.setOuDetailList(finSetOfBookOuDTOList.stream().filter(finSetOfBookOuDTO -> finSetOfBookDTO.getId().equals(finSetOfBookOuDTO.getMasId())).collect(Collectors.toList()));
        }
        return PagingVO.builder().total(query.fetchCount()).records(finSetOfBookDTOList).build();
    }

    public List<FinSetOfBookDTO> selectFinSet(FinSetOfBookParam finSetOfBookParam) {
        Predicate where = this.where(finSetOfBookParam);
        JPAQuery query = (JPAQuery)this.select(FinSetOfBookDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        query.orderBy(this.qFinSetOfBookDO.createTime.desc());
        List fetch = query.fetch();
        return fetch;
    }

    private Predicate where(FinSetOfBookParam finSetOfBookParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(finSetOfBookParam.getId() != null, this.qFinSetOfBookDO.id, (Object)finSetOfBookParam.getId()).andLike(StringUtils.isNotEmpty((String)finSetOfBookParam.getSobCode()), (StringExpression)this.qFinSetOfBookDO.sobCode, StringUtil.buildLikeString(finSetOfBookParam.getSobCode())).andLike(StringUtils.isNotEmpty((String)finSetOfBookParam.getSobName()), (StringExpression)this.qFinSetOfBookDO.sobName, StringUtil.buildLikeString(finSetOfBookParam.getSobName())).andEq(finSetOfBookParam.getStatus() != null, (SimpleExpression)this.qFinSetOfBookDO.status, (Object)finSetOfBookParam.getStatus()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinSetOfBookDO.id, this.qFinSetOfBookDO.sobCode, this.qFinSetOfBookDO.sobName, this.qFinSetOfBookDO.accountPeriodCode, this.qFinSetOfBookDO.accountPeriodName, this.qFinSetOfBookDO.currCode, this.qFinSetOfBookDO.currName, this.qFinSetOfBookDO.status, this.qFinSetOfBookDO.createTime, this.qFinSetOfBookDO.creator, this.qFinSetOfBookDO.modifyTime, this.qFinSetOfBookDO.updater})).from((EntityPath)this.qFinSetOfBookDO);
    }

    public FinSetOfBookDO findById(Long id) {
        Optional finSetOfBookDOOptional = this.finSetOfBookRepo.findById(id);
        Assert.isTrue((boolean)finSetOfBookDOOptional.isPresent(), (String)"\u8d26\u5957\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (FinSetOfBookDO)finSetOfBookDOOptional.get();
    }

    public FinSetOfBookDO findBySobCode(String sobCode) {
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCode(sobCode);
        if (CollectionUtils.isNotEmpty(finSetOfBookDOList)) {
            Assert.equals((Object)finSetOfBookDOList.size(), (Object)1, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u5957", (Object[])new Object[0]);
            return finSetOfBookDOList.get(0);
        }
        return null;
    }

    public FinSetOfBookDO findBySobCodeAndStatus(String sobCode, String status) {
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCodeAndStatus(sobCode, status);
        if (CollectionUtils.isNotEmpty(finSetOfBookDOList)) {
            Assert.equals((Object)finSetOfBookDOList.size(), (Object)1, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u5957", (Object[])new Object[0]);
            return finSetOfBookDOList.get(0);
        }
        return null;
    }

    public FinSetOfBookRepoProc(JPAQueryFactory jpaQueryFactory, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookLineRepo finSetOfBookLineRepo, FinSetOfBookOuRepo finSetOfBookOuRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
    }
}

