package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigQueryVO;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */

@RestController
@RequestMapping("/account/rule/config")
@Api(value = "账户规则配置", tags = {"账户规则配置"})
@AllArgsConstructor
public class AccountRuleConfigController {

    private final AccountRuleConfigService accountRuleConfigService;

    @PostMapping("/page")
    @ApiOperation("账户规则配置-分页查询")
    public ApiResult<PagingVO<AccountRuleConfigPageVO>> page(@RequestBody AccountRuleConfigQueryParam param) {
        val ret = accountRuleConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }
    @PostMapping("/detail/{masId}")
    @ApiOperation("账户规则配置-详情")
    public ApiResult<AccountRuleConfigQueryVO> detail(@PathVariable("masId") Long masId) {
        val ret = accountRuleConfigService.detail(masId);
        return ApiResult.ok(ret);
    }
    @PostMapping("/save")
    @ApiOperation("账户规则配置-保存/更新")
    public ApiResult<Void> save(@RequestBody AccountRuleConfigSaveParam param) {
        accountRuleConfigService.saveOrUpdate(param);
        return ApiResult.ok();
    }
    @GetMapping("/del/{masId}")
    @ApiOperation("账户规则配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        accountRuleConfigService.del(masId);
        return ApiResult.ok();
    }
}