package com.elitesland.fin.entity.flow;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 * @desc : 账户流水
 */
@Entity
@Table(name="account_flow")
@org.hibernate.annotations.Table(appliesTo = "account_flow", comment = "账户流水")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountFlowDO extends CustomFieldBaseModel {

    @Column(name = "company_code", columnDefinition = "varchar(32) comment '公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String companyCode;

    @Column(name = "sec_franchisee_code", columnDefinition = "varchar(32) comment '归属加盟商编码'")
    private String secFranchiseeCode;

    @Column(name = "flow_no", columnDefinition = "varchar(32) comment '流水号'")
    private String flowNo;

    @Column(name = "transaction_type", columnDefinition = "varchar(32) comment '交易类型'")
    private String transactionType;

    @Column(name = "amount", columnDefinition = "decimal(18,8) comment '发生金额'")
    private BigDecimal amount;

    @Column(name = "transaction_time", columnDefinition = "datetime(6) comment '交易日期'")
    private LocalDateTime transactionTime;

    @Column(name = "account_holder_name", columnDefinition = "varchar(32) comment '开户主体名称'")
    private String accountHolderName;

    @Column(name = "account_type", columnDefinition = "varchar(32) comment '账户类型'")
    private String accountType;

    @Column(name = "account_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accountCode;

    @Column(name = "account_name", columnDefinition = "varchar(32) comment '账户名称'")
    private String accountName;

    @Column(name = " account_amount", columnDefinition = "decimal(18,8) comment '账户金额'")
    private BigDecimal accountAmount;

    @Column(name = "account_occupancy_amount", columnDefinition = "decimal(18,8) comment '账户占用金额'")
    private BigDecimal accountOccupancyAmount;

    @Column(name = "account_available_amount", columnDefinition = "decimal(18,8) comment '账户可用金额'")
    private BigDecimal accountAvailableAmount;

    @Column(name = "source_doc", columnDefinition = "varchar(128) comment '来源单据'")
    private String sourceDoc;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人id'")
    private Long auditUserId;

    @Column(name = "audit_user_name", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUserName;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "order_status", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "rule_code", columnDefinition = "varchar(32)  comment '账户规则编码'")
    private String ruleCode;

    @Column(name = "priority_no", columnDefinition = "int(6)  comment '优先级'")
    private Integer priorityNo;

    @Column(name = "source_doc_status", columnDefinition = "varchar(32) comment '来源单据状态'")
    private String sourceDocStatus;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;

    @Column(name = "business_type", columnDefinition = "varchar(40) comment '业务类型'")
    private String businessType;

    @Column(name = "t_ou_code", columnDefinition = "varchar(32) comment '交易授信组织/交易公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String tOuCode;

    @Column(name = "relate_flow_no", columnDefinition = "varchar(32) comment '关联流水号'")
    private String relateFlowNo;

    @Column(name = "sync_status", columnDefinition = "varchar(32) comment '同步状态'")
    private String syncStatus;

    @Column(name = "sync_log", columnDefinition = "text comment '同步异常日志'")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    @Column(name = "from_account_no", columnDefinition = "varchar(32) comment '出账方账号'")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    @Column(name = "to_account_no", columnDefinition = "varchar(32) comment '入账方账号'")
    private String toAccountNo;

    @Column(name = "from_ou_code", columnDefinition = "varchar(32) comment '出账公司'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String fromOuCode;

    @Column(name = "to_ou_code", columnDefinition = "varchar(32) comment '入账公司'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String toOuCode;

    @ApiModelProperty("来源根单据类型")
    @Column(name = "root_doc", columnDefinition = "varchar(32) comment '来源根单据类型'")
    private String rootDoc;

    @ApiModelProperty("来源根单号")
    @Column(name = "root_doc_no", columnDefinition = "varchar(32) comment '来源根单号'")
    private String rootDocNo;
}
