package com.elitesland.fin.application.facade.dto.flowrepair;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/13
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "creditAccountFlowRepairHandle20DTO",description = "账户流水修复重算处理计算20DTO")
public class CreditAccountFlowRepairHandle20DTO implements Serializable {
    private static final long serialVersionUID = 3164502718870949069L;

    @ApiModelProperty(value = "流水修复表的ID")
    private Long flowRepairId;


    @ApiModelProperty(value = "流水修复表的流水号")
    private String flowRepairFlowNo;

    @ApiModelProperty(value = "流水表的ID")
    private Long flowId;

    @ApiModelProperty(value = "流水表的流水号")
    private String flowNo;

    @ApiModelProperty(value = "实际金额")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "变动金额")
    private BigDecimal variableAmount;

    @ApiModelProperty(value = "账户类型")
    private String accountType;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty("交易类型")
    private String transactionType;


    @ApiModelProperty("账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("可用额度")
    private BigDecimal creditAccountAvailableLimit;




    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ApiModelProperty("信用账户类型")
    private String creditAccountType;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("对象名称")
    private String objectName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("前一条账户额度")
    private BigDecimal prevCreditAccountLimit;

    @ApiModelProperty("前一条账户使用额度")
    private BigDecimal prevCreditAccountUsedLimit;

    @ApiModelProperty("前一条占用额度")
    private BigDecimal prevCreditAccountOccupancyLimit;

    @ApiModelProperty(value = "前一条流水表的流水号")
    private String prevFlowNo;

    @ApiModelProperty(value = "前一条审核时间")
    private LocalDateTime prevAuditDate;


    @ApiModelProperty("和前一条金额差值")
    private BigDecimal differenceValue;


    @ApiModelProperty(value = "重算原因 [UDC]yst-fin:FLOW_RECALCUL_REASON")
    private String recalculationReason;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;
}
