package com.elitesland.fin.application.facade.param.recorder;

import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-08 12:25
 */
@Data
public class RecOrderExPageParam extends RecOrderPageParam {

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("公司编码")
    private String recOuCode;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("金额")
    private BigDecimal totalAmtFrom;

    @ApiModelProperty("金额")
    private BigDecimal totalAmtTo;

    @ApiModelProperty("第三方收款单号")
    private String sourceNo;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDateStart;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDateEnd;

    @ApiModelProperty("发票号码")
    private String invoiceNumber;

    @ApiModelProperty("业务员")
    private String businessCode;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("开票备注")
    private String remark;

    @ApiModelProperty("创建开始日期")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建结束日期")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("红冲标志")
    private Boolean redFlushSign;

    @ApiModelProperty("期初标志")
    private Boolean initFlag;

    @ApiModelProperty("核销状态")
    private List<String> verStateList;

    @ApiModelProperty("ids")
    private List<Long> ids;

    @ApiModelProperty(value = "表头标识符")
    private Boolean headFlag;

}
