package com.elitesland.fin.application.facade.vo.adjustorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:49
 */
@Data
public class AdjustOrderVO extends CustomFieldBaseModelVo {

    private static final long serialVersionUID = 7686520477260552365L;
    @ApiModelProperty("单号")
    private String docNo;

    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    @ApiModelProperty("单据状态")
    private String state;
    private String stateName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-fin",mod = "ADJUST_ORDER_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("账户名称")
    @SysCode(sys = "yst-fin", mod = "UNION_PAY",nameField = "accNameName")
    private String accName;
    private String accNameName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accType;
    private String accTypeName;

    @ApiModelProperty("总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("调整原因")
    @SysCode(sys = "yst-fin",mod = "ADJUST_REASON")
    private String adjReason;
    private String adjReasonName;

    @ApiModelProperty("调整类型")
    @SysCode(sys = "yst-fin",mod = "ADJUST_TYPE")
    private String adjType;
    private String adjTypeName;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    @ApiModelProperty("流程实例状态名称")
    private String procInstStatusName;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("储值公司银行账号")
    private String storedBankAcc;
}
