package com.elitesland.fin.application.facade.vo.report;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "IPV账单响应对象")
public class IpvRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = 3645974284132628873L;

    @ApiModelProperty("应付单号")
    private String apOrderNo;

    @ApiModelProperty("收退货单号")
    private String sourceDocNo;

    @ApiModelProperty("收退货行号")
    private Integer sourceLineNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    private String itemType;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("数量")
    private BigDecimal apQty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("库存会计期间")
    private String accountPeriod;

    @ApiModelProperty("当期销售出库数量")
    private BigDecimal saleQty;

    @ApiModelProperty("销售占比")
    private BigDecimal saleRatio;

    @ApiModelProperty("IPV")
    private BigDecimal ipv;

    @ApiModelProperty("销售占比金额")
    private BigDecimal ratioAmt;

    @ApiModelProperty("小类编码")
    private String smallCateCode;

    @ApiModelProperty("小类名称")
    private String smallCateName;

}
