package com.elitesland.fin.application.service.workflow.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayApplyApprovalDTO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aptype.ApTypeVO;
import com.elitesland.fin.application.facade.vo.writeoff.*;
import com.elitesland.fin.application.service.aptype.ApTypeService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyDO;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.apordertopay.ApOrderToPayRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/5/7 13:26
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PayOrderProcessServiceImpl implements PayOrderProcessService {

    @Autowired
    @Lazy
    private RecOrderService recOrderService;
    private final RecTypeDomainService recTypeDomainService;
    private final ApTypeService apTypeService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiPurRpcService rmiPurRpcService;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final ApOrderDtlDomainService apOrderDtlDomainService;
    private final PayOrderDtlDomainService payOrderDtlDomainService;
    private final FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;
    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;
    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final PayOrderRepoProc payOrderRepoProc;

    private final JPAQueryFactory jpaQueryFactory;

    private final FinApPayVerApplyService finApPayVerApplyService;
    private final RecOrderDomainService recOrderDomainService;
    @PersistenceContext
    private EntityManager entityManager;
    private final TaskExecutor taskExecutor;
    private final ApOrderToPayDomainService apOrderToPayDomainService;

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        PayOrderDTO payOrderDTO = payOrderRepoProc.queryById(id);
        log.info("付款单核销详情1:{}", JSONUtil.toJsonStr(payOrderDTO));
        List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlRepoProc.queryByMasId(id);
        if (payOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QPayOrderDO payOrderDO = QPayOrderDO.payOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(payOrderDO)
                .set(payOrderDO.procInstStatus, procInstStatus)
                .where(payOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(payOrderDO.procInstId, (String) null);
                break;
            //审批中 业务依旧是草稿
            case APPROVING:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(payOrderDO.submitTime, LocalDateTime.now());
                break;
            // 审批拒绝 业务数据已拒绝
            case REJECTED:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(payOrderDO.approvedTime, LocalDateTime.now())
                        .set(payOrderDO.auditDate, LocalDateTime.now())
                        .set(payOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(payOrderDO.auditRejection, commentInfo.getComment())
                        .set(payOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(payOrderDO.approvedTime, LocalDateTime.now())
                        .set(payOrderDO.auditDate, LocalDateTime.now())
                        .set(payOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(payOrderDO.auditRejection, commentInfo.getComment())
                        .set(payOrderDO.auditUser, commentInfo.getUserName())
                        .set(payOrderDO.procInstId, (String) null);
                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(payOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                        .set(payOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                        .set(payOrderDO.approvedTime, LocalDateTime.now())
                        .set(payOrderDO.auditDate, LocalDateTime.now())
                        .set(payOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(payOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        //获取供应商类型
        PayOrderDTO orderDTO = payOrderRepoProc.queryById(id);
        String suppType2 = getSuppType2(orderDTO);
        List<RecOrderDO> data = recOrderRepoProc.findBySourceNo(orderDTO.getPayOrderNo());

        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {

            //付款单的供应商类型=系统内，审批通过后同步生成审批通过的收款单。如果收款单中来源单号已经有此付款单，禁止生成。

            if ("INNER".equals(suppType2)) {
                if (CollUtil.isEmpty(data)) { //没有关联的收款单
                    //付款单的来源单据是收款单时审批通过不用生成收款单
                    if (!Objects.equals(payOrderDTO.getCreateMode(), "REC")) {
                        RecOrderSaveParam recOrderSaveParam = getRecOrderSaveParam(payOrderDTO, payOrderDtlDTOS);
                        Long redOrderId = recOrderService.save(recOrderSaveParam).computeData();
                        entityManager.flush();
                        entityManager.clear();
                        //外部客户
                        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(redOrderId);
                        log.info("付款单生成审批通过的收款单详情:{}", JSONUtil.toJsonStr(recOrderDTO));
                        if (isOutterCust(recOrderDTO)) {
                            log.info("外部客户,审批完成自动创建账户流水");
                            recOrderDomainService.createFinFlow(recOrderDTO);
                        }
                    }

                }
            }

            log.info("付款单审批通过，准备将付款单联动的核销单审批通过");
            //动将生成的审批中的应付付款核销单审批通过并核销掉
            List<FinApPayVerApplyDO> apPayVerApplyDOS = finApPayVerApplyRepoProc.finApPayVerApplyByPayId(id);
            if (CollUtil.isNotEmpty(apPayVerApplyDOS)) {
                //审批通过执行核销
                List<String> applyDocNos = apPayVerApplyDOS.stream().map(FinApPayVerApplyDO::getApplyDocNo).collect(Collectors.toList());
                log.info("审批通过后，将对应单据核销掉并且审批通过,应付付款核销单ids:{}", JSONUtil.toJsonStr(applyDocNos));
                FinApPayApplyApprovalDTO dto = new FinApPayApplyApprovalDTO();
                dto.setApplyNos(applyDocNos);
                dto.setApprovalType(FinApPayApplyApprovalDTO.ApprovalType.APPROVE);
                finApPayVerApplyService.writeOffApprove(dto);
                //变更核销单审批状态为审批通过
                finApPayVerApplyRepoProc.approveByDocNos(applyDocNos);
                log.info("付款单审批通过，完成将付款单联动的核销单审批通过");
            }
            PayOrderDTO payOrderDTO2 = payOrderRepoProc.queryById(id);
            List<PayOrderDtlDTO> orderDtlDTOS = payOrderDtlRepoProc.queryByMasId(id);
            log.info("付款单核销详情2:{},明细:{}", JSONUtil.toJsonStr(payOrderDTO2), JSONUtil.toJsonStr(orderDtlDTOS));
            if (orderDtlDTOS == null) {
                log.info("未核销金额不存在,不触发自动核销");
                return;
            }
            BigDecimal unVerAmtTotal =
                    orderDtlDTOS.stream().map(PayOrderDtlDTO::getUnVerAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO,
                            BigDecimal::add);
            if (unVerAmtTotal.compareTo(BigDecimal.ZERO) <= 0) {
                log.info("未核销金额为0,不触发自动核销");
                return;
            }

            //异步
            CompletableFuture.runAsync(() -> {
                //自动核销
                finApPayVerApplyService.autoWriteoffPay(payOrderDTO2);
                //处理核销状态
                updateVerState(id);
            }, taskExecutor);

        }
        if (procInstStatus.equals(ProcInstStatus.REJECTED) || procInstStatus.equals(ProcInstStatus.NOTSUBMIT)) {
            //需要将提交后生成的审批中状态的应付付款核销单取消审批且删除
            List<Long> byPayId = finApPayVerApplyPayRepoProc.findByPayId(id);
            if (CollUtil.isEmpty(byPayId)) {
                return;
            }
            List<Long> ids = finApPayVerApplyPayHeadRepoProc.findByPayId(byPayId);
            if (CollUtil.isEmpty(ids)) {
                return;
            }
            log.info("审批拒绝或驳回,删除应付付款核销单ids:{}", JSONUtil.toJsonStr(ids));
            //过滤掉失效数据
            ids =
                    finApPayVerApplyRepoProc.findAllByIds(ids).stream().filter(e -> "NOT".equals(e.getVerState())).map(BaseModel::getId).distinct().collect(Collectors.toList());
            log.info("审批拒绝或驳回,过滤后的付款核销单ids:{}", JSONUtil.toJsonStr(ids));
            //回写应付单,收款单明细
            for (Long apPayVerApplyId : ids) {
                FinApPayVerApplyVO detail = finApPayVerApplyService.writeOffDetail(apPayVerApplyId);
                log.info("核销申请单详情:{}", JSONUtil.toJsonStr(detail));
                List<FinApPayVerApplyApVO> apList = new ArrayList<>();
                for (FinApPayVerApplyApHeadVO apHeadVO : detail.getApHeadList()) {
                    apList.addAll(apHeadVO.getApList());
                }
                List<FinApPayVerApplyPayVO> payList = new ArrayList<>();
                for (FinApPayVerApplyPayHeadVO payHeadVO : detail.getPayHeadList()) {
                    payList.addAll(payHeadVO.getPayList());
                }

                List<Long> apDIds =
                        apList.stream().filter(e -> e.getApDId() != null).map(FinApPayVerApplyApVO::getApDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> apDIdVerAmtMap =
                        apList.stream().filter(e -> e.getApDId() != null).collect(Collectors.toMap(FinApPayVerApplyApVO::getApDId,
                                FinApPayVerApplyApVO::getVerAmt));

                List<Long> payDIds =
                        payList.stream().filter(e -> e.getPayDId() != null).map(FinApPayVerApplyPayVO::getPayDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> payDIdVerAmtMap =
                        payList.stream().filter(e -> e.getPayDId() != null).collect(Collectors.toMap(FinApPayVerApplyPayVO::getPayDId,
                                FinApPayVerApplyPayVO::getVerAmt));
                log.info("审批拒绝或驳回,回写参数:apDIdVerAmtMap:{},apDIds:{},payDIdVerAmtMap:{},payDIds:{}",
                        JSONUtil.toJsonStr(apDIdVerAmtMap), apDIds, JSONUtil.toJsonStr(payDIdVerAmtMap), payDIds);
                if (MapUtil.isNotEmpty(apDIdVerAmtMap) && CollUtil.isNotEmpty(apDIds)) {
                    apOrderDtlDomainService.resortVerAmt(apDIdVerAmtMap, apDIds);
                }
                if (MapUtil.isNotEmpty(payDIdVerAmtMap) && CollUtil.isNotEmpty(payDIds)) {
                    payOrderDtlDomainService.resortVerAmt(payDIdVerAmtMap, payDIds);
                }
            }
            payOrderRepoProc.updateVerApplyFlag(id, "0");
            log.info("审批驳回撤回,将付款的核销申请单标识重新设置为0");
            if (CollUtil.isNotEmpty(ids)) {
                finApPayVerApplyRepoProc.deleteByIds(ids);
            }
            log.info("审批驳回撤回完成");
        }
        //增加校验，如果付款单的供应商类型=系统内，且已经生成关联的收款单，不允许取消审批
        if (procInstStatus.equals(ProcInstStatus.NOTSUBMIT)) {
            if ("INNER".equals(suppType2)) {
                if (CollUtil.isNotEmpty(data)) { //没有关联的收款单
                    throw new com.elitescloud.boot.exception.BusinessException("改单据已经生成关联的收款单，不允许取消审批");
                }
            }
        }
        //付款单作废需要删除ap_order_to_pay表关联数据
        if (procInstStatus.equals(ProcInstStatus.INVALID)) {
            apOrderToPayDomainService.deleteByPayId(id);
        }
    }

    //是否是外部客户
    private boolean isOutterCust(RecOrderDTO recOrderDTO) {
        String inOutCust = recOrderDTO.getInOutCust();
        if ("OUT".equals(inOutCust)) {
            return true;
        } else {
            return false;
        }
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<ApTypeVO> apTypeVOS = apTypeService.getList().computeData();
        Optional<ApTypeVO> first = apTypeVOS.stream().filter(e -> e.getApTypeCode().equals(code)).findFirst();
        return first.map(ApTypeVO::getId).orElse(null);
    }

    private Long getRecTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<RecTypeDTO> apTypeDTOS = recTypeDomainService.findAll();
        Optional<RecTypeDTO> first = apTypeDTOS.stream().filter(e -> e.getRecTypeCode().equals(code)).findFirst();
        return first.map(RecTypeDTO::getId).orElse(null);
    }

    private RecOrderSaveParam getRecOrderSaveParam(PayOrderDTO orderDTO, List<PayOrderDtlDTO> payOrderDtlDTOS) {
        log.info("生成收款单入参:orderDTO:{},payOrderDtlDTOS:{}", JSONUtil.toJsonStr(orderDTO),
                JSONUtil.toJsonStr(payOrderDtlDTOS));
        //获取供应商信息
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(Arrays.asList(orderDTO.getSuppCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("付款单公司供应商信息不存在");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        log.info("供应商信息:{}", JSONUtil.toJsonStr(purSuppBaseRpcDTO));
        String ouCode2 = purSuppBaseRpcDTO.getOuCode2();
        List<OrgOuRpcSimpleDTO> baseOuByCodes =
                rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(ouCode2));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("供应商关联的公司信息不存在");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("客户关联公司信息:{}", JSONUtil.toJsonStr(orgOuRpcSimpleDTO));

        //获取客户信息
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCorBusinCodes(Arrays.asList(orderDTO.getOuCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("客户信息:{}", JSONUtil.toJsonStr(custBaseDTO));

        RecOrderSaveParam param = new RecOrderSaveParam();
        //内外部
        param.setInOutCust(custBaseDTO.getInOutCust());
        //销售公司
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        //客户
        param.setCustCode(custBaseDTO.getCustCode());
        param.setCustId(custBaseDTO.getId());
        param.setCustName(custBaseDTO.getCustName());
        //收款单类型
        param.setRecTypeCode("SKD01_SYS");
        param.setRecTypeName("标准收款单");
        param.setRecTypeId(getRecTypeIdByCode("SKD01_SYS"));
        //收款日期
        param.setReDate(orderDTO.getApDate());
        //币种
        param.setCurrCode(orderDTO.getCurrCode());
        param.setCurrName(orderDTO.getCurrName());
        //来源单据
        param.setCreateMode("PAY");
        //收款公司
        param.setRecOuId(orderDTO.getSuppId());
        param.setRecOuCode(orderDTO.getSuppCode());
        param.setRecOuName(orderDTO.getSuppName());
        //汇率
        param.setExchangeRate(orderDTO.getExchangeRate());
        //总金额
        param.setTotalAmt(orderDTO.getTotalAmt());
        //总金额（本位币)
        param.setTotalCurAmt(orderDTO.getTotalCurAmt());
        //实际收款金额
        param.setRealRecAmt(orderDTO.getRealPayAmt());
        //实际收款金额（本位币）
        param.setRealRecCurAmt(orderDTO.getRealPayCurAmt());
        //是否预收
        param.setReFlag(orderDTO.getApFlag());
        //是否期初
        param.setInitFlag(orderDTO.getInitFlag());
        //单据状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(orderDTO.getRedState());
        //红冲对应原单号
        String redSourceNo = orderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank(redSourceNo)) {
            List<RecOrderDO> bySourceNo = recOrderRepoProc.findBySourceNo(redSourceNo);
            if (CollUtil.isNotEmpty(bySourceNo)) {
                RecOrderDO recOrderDO = bySourceNo.get(0);
                param.setRedSourceNo(recOrderDO.getRecOrderNo());
                param.setRedSourceId(recOrderDO.getId());
                param.setRedState(true);
            }
        }
        //拟定状态
        param.setProposedStatus("DRAFT");
        //来源单号
        param.setSourceNo(orderDTO.getPayOrderNo());

        //明细行
        List<RecOrderDtlSaveParam> orderDtlSaveParamList = payOrderDtlDTOS.stream().map(
                payOrderDtlDTO -> {
                    RecOrderDtlSaveParam dtlSaveParam = new RecOrderDtlSaveParam();
                    dtlSaveParam.setSourceLine(payOrderDtlDTO.getSourceLine());
                    dtlSaveParam.setSourceLineId(payOrderDtlDTO.getSourceLineId());
                    dtlSaveParam.setRecType(payOrderDtlDTO.getPayType());
                    dtlSaveParam.setRecTypeName(payOrderDtlDTO.getPayTypeName());
                    dtlSaveParam.setRecAccount(payOrderDtlDTO.getRecAccount());
                    dtlSaveParam.setRecBank(payOrderDtlDTO.getRecBank());
                    dtlSaveParam.setEs16(payOrderDtlDTO.getPayAccount());
                    dtlSaveParam.setEs17(payOrderDtlDTO.getPayBank());

                    dtlSaveParam.setTotalAmt(payOrderDtlDTO.getTotalAmt());
                    dtlSaveParam.setTotalCurAmt(payOrderDtlDTO.getTotalCurAmt());
                    dtlSaveParam.setTaxRate(BigDecimal.ZERO);
                    dtlSaveParam.setTaxAmt(BigDecimal.ZERO);
                    dtlSaveParam.setRealRecAmt(payOrderDtlDTO.getRealPayAmt());
                    dtlSaveParam.setRealRecCurAmt(payOrderDtlDTO.getRealPayCurAmt());
                    dtlSaveParam.setVerAmt(BigDecimal.ZERO);
                    dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
                    dtlSaveParam.setUnVerAmt(param.getTotalAmt());

                    return dtlSaveParam;
                }
        ).collect(Collectors.toList());
        param.setOrderDtlSaveParamList(orderDtlSaveParamList);
        log.info("生成收款单参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }


    private String getSuppType2(PayOrderDTO orderDTO) {
        Long suppId = orderDTO.getSuppId();
        List<PurSuppBaseDTO> bySuppIdBatch = rmiPurRpcService.findBySuppIdBatch(Collections.singletonList(suppId));
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new com.elitescloud.boot.exception.BusinessException("单据对应供应商信息不存在");
        }
        PurSuppBaseDTO purSuppBaseDTO = bySuppIdBatch.get(0);
        return purSuppBaseDTO.getSuppType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        PayOrderDTO payOrderDTO = payOrderRepoProc.queryById(businessId);
        if (payOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(payOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }

    private void updateVerState(Long id) {
        //处理核销状态
        PayOrderDTO newPayOrderDTO = payOrderRepoProc.queryById(id);
        List<PayOrderDtlDTO> newPayOrderDtlDTOList = payOrderDtlRepoProc.queryByMasId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newPayOrderDtlDTOList)) {
            for (PayOrderDtlDTO payOrderDtlDTO : newPayOrderDtlDTOList) {
                if (null != payOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(payOrderDtlDTO.getVerAmt());
                }
                if (payOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(payOrderDtlDTO.getApplyVerAmTing());
                }
                if (payOrderDtlDTO.getUnVerAmt() != null) {
                    unVerAmtSum = unVerAmtSum.add(payOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newPayOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newPayOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newPayOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newPayOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/

        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newPayOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newPayOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)) {
            payOrderRepoProc.updateVerState(verState, id);
        }

    }
}
