package com.elitesland.fin.repo.account;

import com.elitesland.fin.entity.account.AccountSnapshotDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public interface AccountSnapshotRepo extends JpaRepository<AccountSnapshotDO, Long>, QuerydslPredicateExecutor<AccountSnapshotDO> {

    /**
     * 根据账户编码查询
     * @param accountCodes
     * @return
     */
    List<AccountSnapshotDO> findAllByAccountCodeIn(List<String> accountCodes);
}
