package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlRecordConvert;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlRecordDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlRecordDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderRecordDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRecordRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRecordRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/28
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class ArOrderDtlRecordDomainServiceImpl implements ArOrderDtlRecordDomainService {

    private final ArOrderDtlRecordRepo arOrderDtlRecordRepo;
    private final ArOrderDtlRecordRepoProc arOrderDtlRecordRepoProc;


    @Override
    @SysCodeProc
    public List<ArOrderDtlRecordDTO> selectByMasId(List<Long> masIds) {
        List<ArOrderDtlRecordDO> arOrderDtlRecordDOList = arOrderDtlRecordRepo.findAllByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(arOrderDtlRecordDOList)){
            return Collections.EMPTY_LIST;
        }

        List<ArOrderDtlRecordDTO> arOrderDtlRecordDTOS = ArOrderDtlRecordConvert.INSTANCE.doConvertDtoBatch(arOrderDtlRecordDOList);
        return arOrderDtlRecordDTOS;
    }

}
