package com.elitesland.fin.application.facade.vo.saleinv;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/8/11
 */
@Data
public class SaleInvDtlAppVO implements Serializable {

    private static final long serialVersionUID = -3296267138204277714L;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("根单据编号")
    private String rootDocNo;

    @ApiModelProperty("对账申请时间")
    private LocalDateTime recApplyTime;

    @ApiModelProperty("根单据下单时间")
    private LocalDateTime rootDocTime;

    @ApiModelProperty("根单据下单时间")
    private List<SaleInvDtlItemAppVO> detailList;

    @Data
    public static class SaleInvDtlItemAppVO {

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("数量")
        private BigDecimal qty;
    }



}
