/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountStorageConvert;
import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.param.account.AccountStorageSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;
import com.elitesland.fin.application.service.account.AccountStorageService;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.application.service.unionpay.UnionPayService;
import com.elitesland.fin.application.service.unionpay.entity.enums.SourceTypeEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcSaveParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTimsParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.param.recorder.RecOrderDtlRpcParam;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.utils.TimeUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountStorageServiceImpl
implements AccountStorageService {
    private static final Logger log = LoggerFactory.getLogger(AccountStorageServiceImpl.class);
    private final UnionPayService unionPayService;
    private final RecOrderRpcTwoService recOrderRpcTwoService;
    @Autowired
    private AccountStorageRepo accountStorageRepo;
    @Autowired
    private AccountStorageRepoProc accountStorageRepoProc;
    private static final Random RANDOM = new Random();

    @Override
    @SysCodeProc
    public PagingVO<AccountStorageVO> page(AccountStorageParam params) {
        return this.accountStorageRepoProc.queryPaging(params);
    }

    @Override
    @SysCodeProc
    public List<AccountStorageVO> list(AccountStorageParam param) {
        return this.accountStorageRepoProc.getList(param);
    }

    @Override
    @Transactional
    @SysCodeProc
    public AccountStorageVO save(AccountStorageSaveParam saveParams) {
        String prefix = TimeUtil.datetime2String(LocalDateTime.now());
        Integer suffix = RANDOM.nextInt(99999);
        StringBuilder payOrderId = new StringBuilder(prefix);
        payOrderId.append(suffix);
        saveParams.setPayOrderId(payOrderId.toString());
        AccountStorageDO accountStorageDO = AccountStorageConvert.INSTANCE.saveToDo(saveParams);
        this.accountStorageRepo.save((Object)accountStorageDO);
        RecOrderRpcSaveParam recOrderRpcSaveParam = new RecOrderRpcSaveParam();
        this.buildRecOrderParam(recOrderRpcSaveParam, saveParams);
        this.recOrderRpcTwoService.saveRecOrder(recOrderRpcSaveParam);
        AccountStorageVO vo = new AccountStorageVO();
        BeanUtils.copyProperties((Object)((Object)accountStorageDO), (Object)((Object)vo));
        return vo;
    }

    @Override
    @Transactional
    public void followPay(AccountStorageFollowReq followReq) {
        String result = this.unionPayService.followPay(followReq);
    }

    @Override
    @SysCodeProc
    public AccountStorageVO single(Long id) {
        AccountStorageDO storageDO = (AccountStorageDO)((Object)this.accountStorageRepo.findById(id).get());
        return AccountStorageConvert.INSTANCE.do2Vo(storageDO);
    }

    private RecOrderRpcSaveParam buildRecOrderParam(RecOrderRpcSaveParam recOrderRpcSaveParam, AccountStorageSaveParam saveParams) {
        recOrderRpcSaveParam.setSourceNo(saveParams.getPayOrderId());
        recOrderRpcSaveParam.setRecTypeCode(saveParams.getReceiptType());
        recOrderRpcSaveParam.setOrderState(saveParams.getReceiptStatus());
        recOrderRpcSaveParam.setRecOrderNo(saveParams.getPayOrderId());
        recOrderRpcSaveParam.setTotalAmt(saveParams.getRemitterAmt());
        recOrderRpcSaveParam.setRealRecAmt(saveParams.getRemitterAmt());
        recOrderRpcSaveParam.setOuCode(saveParams.getSecOuCode());
        recOrderRpcSaveParam.setOuName(saveParams.getSecOuName());
        recOrderRpcSaveParam.setReDate(LocalDateTime.now());
        recOrderRpcSaveParam.setCustCode(saveParams.getAccountHolderCode());
        recOrderRpcSaveParam.setCustName(saveParams.getAccountHolderName());
        recOrderRpcSaveParam.setCreateMode(UdcEnum.FIN_REC_DOC_CLS_SVO.getValueCode());
        recOrderRpcSaveParam.setRecTypeCode(SourceTypeEnum.STORAGE.getCode());
        recOrderRpcSaveParam.setRecTypeName(SourceTypeEnum.STORAGE.getCodeName());
        recOrderRpcSaveParam.setRecOuCode(saveParams.getSecOuCode());
        recOrderRpcSaveParam.setRecOuName(saveParams.getSecOuName());
        recOrderRpcSaveParam.setTaxAmt(BigDecimal.ZERO);
        recOrderRpcSaveParam.setTaxCurAmt(BigDecimal.ZERO);
        recOrderRpcSaveParam.setTotalCurAmt(BigDecimal.ZERO);
        recOrderRpcSaveParam.setRealRecCurAmt(BigDecimal.ZERO);
        recOrderRpcSaveParam.setExchangeRate(BigDecimal.ONE);
        recOrderRpcSaveParam.setCurrCode("CNY");
        recOrderRpcSaveParam.setCurrName("\u4eba\u6c11\u5e01");
        recOrderRpcSaveParam.setLocalCurrCode("CNY");
        recOrderRpcSaveParam.setLocalCurrName("\u4eba\u6c11\u5e01");
        ArrayList<RecOrderDtlRpcParam> detailSaveParamList = new ArrayList<RecOrderDtlRpcParam>();
        RecOrderDtlRpcParam detailSaveParam = new RecOrderDtlRpcParam();
        detailSaveParam.setSourceNo(saveParams.getPayOrderId());
        detailSaveParam.setTotalAmt(saveParams.getRemitterAmt());
        detailSaveParam.setRealRecAmt(saveParams.getRemitterAmt());
        detailSaveParam.setRecType(saveParams.getPayMode());
        detailSaveParam.setRecFlow(saveParams.getPayOrderId());
        detailSaveParam.setTaxAmt(BigDecimal.ZERO);
        detailSaveParam.setTaxCurAmt(BigDecimal.ZERO);
        detailSaveParam.setTotalCurAmt(BigDecimal.ZERO);
        detailSaveParam.setTaxRate(BigDecimal.ZERO);
        detailSaveParam.setRealRecCurAmt(BigDecimal.ZERO);
        detailSaveParam.setRecKind(UdcEnum.SAL_RECEIPT_TYPE_STORAGE.getValueCode());
        detailSaveParamList.add(detailSaveParam);
        recOrderRpcSaveParam.setRecOrderDtlRpcParamList(detailSaveParamList);
        RecOrderRpcTimsParam timsParam = new RecOrderRpcTimsParam();
        timsParam.setRemitterAccount(saveParams.getRemitterAccount());
        timsParam.setRemitterBankCode(saveParams.getRemitterBankCode());
        timsParam.setRemitterBankName(saveParams.getRemitterBankName());
        timsParam.setFranchisee(saveParams.getFranchisee());
        timsParam.setFranchiseeName(saveParams.getFranchiseeName());
        timsParam.setSourceNo(saveParams.getPayOrderId());
        recOrderRpcSaveParam.setRecOrderRpcTimsParam(timsParam);
        return recOrderRpcSaveParam;
    }

    public AccountStorageServiceImpl(UnionPayService unionPayService, RecOrderRpcTwoService recOrderRpcTwoService) {
        this.unionPayService = unionPayService;
        this.recOrderRpcTwoService = recOrderRpcTwoService;
    }
}

