package com.elitesland.fin.application.facade.param.flow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 账户流水;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 */
@Data
@ApiModel(description = "账户流水")
public class AccountFlowParam extends CustomFieldBaseModelVo {
    private static final long serialVersionUID = -5067931732705888337L;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("归属加盟商编码")
    private String secFranchiseeCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private Long sourceId;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("账户规则编码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;

    @ApiModelProperty(value = "是否一个单据生成多个不同账户的流水")
    private Boolean overOneFlow;

    //old
    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("账户进出方式")
    private String accountIoType;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户进出方式")
    private String accIoType;

    @ApiModelProperty("拆分类型")
    private String splitType;

    @ApiModelProperty("生单类型")
    private String birthOrderType;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private boolean automaticReview;

    //rpc
    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal sourceDocAmount;

    @ApiModelProperty("来源单据门店编码")
    private String sourceDocStoreCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("单据")
    private String doc;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal docAmount;

	@ApiModelProperty("工作流实例id")
	private String workflowProcInstId;

    @ApiModelProperty("true 则如果存在流水的时候忽略校验,不再生产流水")
    private Boolean ignore;

    @ApiModelProperty("货款")
    private BigDecimal itemFee;

    @ApiModelProperty("科技费")
    private BigDecimal techFee;

    @ApiModelProperty("营销费")
    private BigDecimal marketingFee;

    @ApiModelProperty("运营费")
    private BigDecimal operationFee;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("货款公司")
    private String itemFeeOuCode;

    @ApiModelProperty("科技费公司")
    private String techFeeOuCode;

    @ApiModelProperty("营销费公司")
    private String marketingFeeOuCode;

    @ApiModelProperty("运营费公司")
    private String operationFeeOuCode;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("交易公司编码")
    private String tOuCode;

    @ApiModelProperty("关联流水号")
    private String relateFlowNo;

    @ApiModelProperty("同步状态")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_FLOW_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("同步异常日志")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    private String toAccountNo;

    @ApiModelProperty("出账公司")
    private String fromOuCode;

    @ApiModelProperty("入账公司")
    private String toOuCode;

    @ApiModelProperty("来源根单据类型")
    private String rootDoc;

    @ApiModelProperty("来源根单号")
    private String rootDocNo;
}
