package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_set_of_book_line")
@org.hibernate.annotations.Table(appliesTo = "fin_set_of_book_line", comment = "账套明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinSetOfBookLineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "column_name", columnDefinition = "varchar(64) comment '字段名称'")
    private String columnName;

    @Column(name = "account_dimen_code", columnDefinition = "varchar(20) comment '核算维度编码'")
    private String accountDimenCode;

    @Column(name = "account_dimen_name", columnDefinition = "varchar(32) comment '核算维度名称'")
    private String accountDimenName;

    @Column(name = "flexible_flag", columnDefinition = "tinyint(1) comment '是否是值集'")
    private Boolean flexibleFlag;

    @Column(name = "flexible_code", columnDefinition = "varchar(20) comment '值集编码'")
    private String flexibleCode;

    @Column(name = "flexible_name", columnDefinition = "varchar(32) comment '值集名称'")
    private String flexibleName;
}
