package com.elitesland.fin.domain.entity.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "receipt_payment_agreement_dtl")
@org.hibernate.annotations.Table(appliesTo = "receipt_payment_agreement_dtl", comment = "收付款协议设置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ReceiptPaymentAgreementDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -5478795177326559297L;

    @Comment("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20)")
    private Long masId;

    @Comment("行号")
    @Column(name = "line_no", columnDefinition = "int(10)")
    private Integer lineNo;

    @Comment("账期类型")
    @Column(name = "period_type", columnDefinition = "varchar(32)")
    private String periodType;

    @Comment("收款分期")
    @Column(name = "collection_installments", columnDefinition = "int(11)")
    private Integer collectionInstallments;

    @Comment("收款比例")
    @Column(name = "collection_ratio", columnDefinition = "decimal(18,8)")
    private BigDecimal collectionRatio;

    @Comment("起效日期")
    @Column(name = "start_effective_date", columnDefinition = "varchar(32)")
    private String startEffectiveDate;

    @Comment("起效日期延迟天数")
    @Column(name = "validity_date_delay_days", columnDefinition = "int(11)")
    private Integer validityDateDelayDays;

    @Comment("账期天数")
    @Column(name = "period_days", columnDefinition = "int(11)")
    private Integer periodDays;

    @Comment("生效附加月")
    @Column(name = "effective_additional_month", columnDefinition = "int(11)")
    private Integer effectiveAdditionalMonth;

    @Comment("生效日")
    @Column(name = "effective_date", columnDefinition = "int(11)")
    private Integer effectiveDate;

}
