package com.elitesland.fin.provider.bip;

import com.elitescloud.cloudt.common.base.ApiResult;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/23 周三
 */
public interface BipFinService {

    /**
     * 推送收款单-扫呗账户流水
     *
     * @param creditAccountFlowId
     */
    ApiResult<String> pushReceiptOfSaoBeiAccountFlow(long creditAccountFlowId);

    /**
     * 推送收款单-储值账户流水
     *
     * @param accountFlowId
     */
    ApiResult<String> pushReceiptOfStorageAccountFlow(long accountFlowId);

    /**
     * 推送收款单-账户调整单
     *
     * @param adjustOrderId
     */
    ApiResult<String> pushReceiptOfAdjustOrder(long adjustOrderId);

    /**
     * 推送付款单-储值账户流水
     *
     * @param accountFlowId
     */
    ApiResult<String> pushPaymentOfStorageAccountFlow(long accountFlowId);
}
