/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.PaymentRecordTypeEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infinity.aisino.enums.RedStateEnum;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.InvoiceRequestSerialNoParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoBlueResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.BlueInvoiceApplyRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.InvoiceResultRespVO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Service
public abstract class AbstractInvoiceSaveServiceImpl
implements InvoiceSaveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractInvoiceSaveServiceImpl.class);
    protected static final Map<PaymentRecordTypeEnum, AbstractInvoiceSaveServiceImpl> SERVICE_MAP = new HashMap<PaymentRecordTypeEnum, AbstractInvoiceSaveServiceImpl>();
    @Autowired
    protected SaleInvRepoProc saleInvRepoProc;
    @Autowired
    @Lazy
    protected AisinoService aisinoService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    @Lazy
    private InvoiceAwaitService invoiceAwaitService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private SaleInvRepo saleInvRepo;
    @Autowired
    private SaleInvDtlRepoProc saleInvDtlRepoProc;
    @Autowired
    private InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    @Autowired
    private SaleInvDomainService saleInvDomainService;
    @Autowired
    private WorkflowRpcService workflowRpcService;
    @Autowired
    private MessageQueueTemplate messageQueueTemplate;
    @Autowired
    private SaleInvDtlRepo saleInvDtlRepo;
    @Autowired
    private SaleInvdDtlRepo saleInvdDtlRepo;
    @Autowired
    private AisinoPayloadService aisinoPayloadService;

    public void afterPropertiesSet() {
        SERVICE_MAP.put(this.getSourceType(), this);
    }

    protected abstract PaymentRecordTypeEnum getSourceType();

    protected abstract void callBackMethod(List<InvoiceAwaitRespVO> var1);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceSaveVO> save(InvoiceApplyParam param) {
        PaymentRecordTypeEnum strategyEnum;
        log.info("\u5f00\u59cb\u4fdd\u5b58\u5f00\u7968\u5355,\u5165\u53c2\u4e3a{}", (Object)JSON.toJSONString((Object)param));
        List<InvoiceAwaitRespVO> records = this.invoiceAwaitService.checkAndQueryInvoiceAwait(param);
        String sourceType = this.getSourceType(records);
        try {
            strategyEnum = PaymentRecordTypeEnum.valueOf(sourceType);
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u672a\u5b9a\u4e49");
        }
        AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService = SERVICE_MAP.get((Object)strategyEnum);
        if (Objects.isNull(abstractInvoiceSaveService)) {
            throw new BusinessException("\u672a\u5b9a\u4e49\u6b64\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b\uff0c\u7c7b\u578b\u4e3a" + strategyEnum);
        }
        final List<InvoiceApplySaveParam> saveParamList = this.invoiceAwaitService.getInvoiceApplySaveParams(records);
        log.info("\u5f00\u59cb\u8c03\u7528\u5f00\u7968\u5355\u521b\u5efa\u65b9\u6cd5,\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString(saveParamList));
        ArrayList applyList = new ArrayList();
        saveParamList.forEach(saveParam -> {
            saveParam.setInvType(param.getInvType());
            saveParam.setRemark(param.getRemark());
            saveParam.setInvCustCode(param.getInvCustCode());
            saveParam.setInvCustName(param.getInvCustName());
            saveParam.setInvCustId(param.getInvCustId());
            saveParam.setCustInvTitle(param.getCustInvTitle());
            saveParam.setCustTaxNo(param.getCustTaxNo());
            saveParam.setInvType(param.getInvType());
            InvoiceApplyDTO apply = this.saveAndSubmitInvoice((InvoiceApplySaveParam)saveParam);
            Assert.notNull((Object)apply.getApplyNo(), (String)"\u5f00\u7968\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            saveParam.setApplyNo(apply.getApplyNo());
            saveParam.setId(apply.getApplyId());
            this.invoiceAwaitRepoProc.updateApplyNoByIds(apply.getInvoiceAwaitIds(), apply.getApplyNo(), saveParam.getInvoiceAwaitStatus());
            applyList.add(apply);
        });
        ArrayList<InvoiceSaveVO> resultList = new ArrayList<InvoiceSaveVO>();
        for (InvoiceApplyDTO invoiceApplyDTO : applyList) {
            InvoiceSaveVO result = new InvoiceSaveVO();
            result.setApplyId(invoiceApplyDTO.getApplyId());
            result.setApplyNo(invoiceApplyDTO.getApplyNo());
            resultList.add(result);
        }
        abstractInvoiceSaveService.callBackMethod(records);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                CompletableFuture.supplyAsync(() -> {
                    Map saveParamMap = saveParamList.stream().collect(Collectors.toMap(InvoiceApplySaveParam::getApplyNo, Function.identity()));
                    saveParamMap.forEach((key, value) -> AbstractInvoiceSaveServiceImpl.this.aisinoBlueInvoiceApply((InvoiceApplySaveParam)value, null));
                    return null;
                }, (Executor)AbstractInvoiceSaveServiceImpl.this.taskExecutor);
            }
        });
        log.info("\u5f00\u7968\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f\uff0c\u7ed3\u679c\u4e3a{}", (Object)JSON.toJSONString(resultList));
        return resultList;
    }

    public InvoiceApplyDTO saveAndSubmitInvoice(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        if (ObjUtil.notEqual((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            saleInv.setOrderState(UdcEnum.INVOICE_STATUS_SUCCESS.getValueCode());
        } else {
            saleInv.setOrderState(UdcEnum.INVOICE_STATUS_DRAFT.getValueCode());
        }
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        saleInv.check();
        saleInv.checkDtl();
        log.info("[YST-FIN] saleInv: {}", (Object)saleInv);
        this.transactionTemplate.setPropagationBehavior(3);
        SaleInvDO execute = (SaleInvDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
                log.info("[YST-FIN] convertDO: {}", (Object)convertDO);
                this.flexFieldUtilService.handFlexFieldValueFeference("SALE_INV", (Object)convertDO);
                SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(convertDO);
                this.saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
                List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
                List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
                log.info("[YST-FIN] convert details: {}", details);
                details.forEach(row -> {
                    row.setMasId(save.getId());
                    this.saleInvDtlRepo.save(row);
                });
                return save;
            }
            catch (Exception e) {
                log.error("\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                transactionStatus.setRollbackOnly();
                throw new com.elitescloud.boot.exception.BusinessException(ApiCode.FAIL, "\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u4fdd\u5b58\u65f6\u51fa\u9519");
            }
        });
        Set<Long> awaitId = param.getDetails().stream().map(InvoiceDetailSaveParam::getInvoiceAwaitId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ObjUtil.equals((Object)param.getAutoReview(), (Object)Boolean.FALSE) && execute != null) {
            this.workFlow(execute);
        }
        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(execute.getId());
        result.setApplyNo(execute.getApplyNo());
        result.setInvoiceAwaitIds(awaitId);
        return result;
    }

    public void aisinoBlueInvoiceApply(InvoiceApplySaveParam saveParam, SaleInvdDtlDO saleInvdDtlDO) {
        AisinoBlueInvoiceApplyParam applyParam = this.aisinoPayloadService.blueInvoiceApplyInitial(saveParam, saleInvdDtlDO);
        String initialParam = JSON.toJSONString((Object)applyParam);
        AisinoCoverParamPayload finialParam = this.aisinoPayloadService.assembleAisinoPayload(initialParam, saveParam.getSaleTaxNo());
        BlueInvoiceApplyRespVO response = this.aisinoService.blueInvoiceApply(finialParam, initialParam);
        if (saleInvdDtlDO == null) {
            saleInvdDtlDO = new SaleInvdDtlDO();
        }
        saleInvdDtlDO.setMasId(saveParam.getId());
        saleInvdDtlDO.setFlowNo(applyParam.getFPQQLSH());
        BigDecimal totalAmt = new BigDecimal(applyParam.getREQUEST().getJSHJ());
        saleInvdDtlDO.setTotalAmt(totalAmt);
        saleInvdDtlDO.setInvDate(LocalDateTime.now());
        saleInvdDtlDO.setSaleTaxNo(saveParam.getSaleTaxNo());
        if (response.getCODE().equals("0000")) {
            saleInvdDtlDO.setInvState(RedStateEnum.BLUE_APPLY_SUCCESS.getCode());
            saleInvdDtlDO.setInvNo(response.getDATA().getFPHM());
        } else {
            saleInvdDtlDO.setInvState(RedStateEnum.BLUE_APPLY_FAIL.getCode());
            saleInvdDtlDO.setInvFailCause(response.getRETURNMESSAGE());
        }
        this.saleInvdDtlRepo.save(saleInvdDtlDO);
    }

    public void getInvoiceInfoByFlowNo(SaleInvdDtlDO saleInvdDtlDO) {
        InvoiceRequestSerialNoParam applyParam = this.aisinoPayloadService.getInvoiceInfoByFlowNo(saleInvdDtlDO);
        String initialParam = JSON.toJSONString((Object)applyParam);
        AisinoCoverParamPayload finialParam = this.aisinoPayloadService.assembleAisinoPayload(initialParam, saleInvdDtlDO.getSaleTaxNo());
        InvoiceResultRespVO response = this.aisinoService.getInvoiceInfoByFlowNo(finialParam, initialParam);
        if (Objects.equals(response.getCODE(), "200")) {
            InvoiceResultRespVO.Data data1 = response.getDATA();
            saleInvdDtlDO.setInvNo(data1.getFPHM());
            saleInvdDtlDO.setInvDate(LocalDateTime.parse(data1.getKPRQ()));
            switch (data1.getKPZT()) {
                case "1": {
                    saleInvdDtlDO.setInvState(RedStateEnum.BLUE_OPEN_SUCCESS.getCode());
                    break;
                }
                case "2": {
                    saleInvdDtlDO.setInvState(RedStateEnum.BLUE_OPEN_FAIL.getCode());
                    break;
                }
                case "0": {
                    saleInvdDtlDO.setInvState(RedStateEnum.BLUE_OPENING.getCode());
                }
            }
        } else {
            log.error("[YST-FIN] \u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u53d1\u7968\u4fe1\u606f:{}", (Object)response.getRETURNMESSAGE());
            saleInvdDtlDO.setInvFailCause(response.getRETURNMESSAGE());
        }
    }

    public void getBlueResult(SaleInvdDtlDO saleInvDO) {
        if (saleInvDO.getInvNo() != null && saleInvDO.getInvDate() != null) {
            String blueResultParam = this.aisinoPayloadService.getBlueResult(saleInvDO.getInvNo(), saleInvDO.getInvDate());
            AisinoCoverParamPayload payload = this.aisinoPayloadService.assembleAisinoPayload(blueResultParam, saleInvDO.getSaleTaxNo());
            AisinoBlueResultResp aisinoBlueResultResp = this.aisinoService.blueInvoiceResult(payload, blueResultParam);
            if (Objects.equals(aisinoBlueResultResp.getCODE(), "0000")) {
                AisinoBlueResultResp.Data data1 = aisinoBlueResultResp.getDATA();
                saleInvDO.setInvState(RedStateEnum.BLUE_RESULT_SUCCESS.getCode());
                saleInvDO.setRedState(RedStateEnum.RED_PUNCH.getCode());
                saleInvDO.setInvPdfUrl(data1.getDATA());
            } else {
                log.error("[YST-FIN] \u83b7\u53d6\u84dd\u7968\u5f00\u7968\u7ed3\u679c\u5931\u8d25:{}", (Object)aisinoBlueResultResp.getRETURNMESSAGE());
                saleInvDO.setInvState(RedStateEnum.BLUE_RESULT_FAIL.getCode());
                saleInvDO.setInvFailCause(aisinoBlueResultResp.getRETURNMESSAGE());
            }
        }
    }

    @NotNull
    private String getSourceType(List<InvoiceAwaitRespVO> records) {
        List<String> sourceType = records.stream().map(InvoiceAwaitRespVO::getOptDocCls).distinct().toList();
        if (CollUtil.isEmpty(sourceType)) {
            throw new BusinessException("\u5f00\u7968\u5931\u8d25\uff1a\u6240\u9009\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
        }
        if (sourceType.size() > 1) {
            throw new BusinessException("\u5f00\u7968\u5931\u8d25\uff1a\u591a\u79cd\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e00\u8d77\u5f00\u7968");
        }
        return sourceType.get(0);
    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        if (saleInvDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            String procInstName = "\u5f00\u7968\u7533\u8bf7(" + applyNo + ")\u5ba1\u6279";
            String businessKey = "" + saleInvDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_SALE_INV.name(), procInstName, businessKey, new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, saleInvDO.getId());
            log.info("\u5f85\u5f00\u53d1\u7968\u7533\u8bf7\u8d70\u5de5\u4f5c\u6d41,\u7533\u8bf7\u9500\u552e\u53d1\u7968\u5355\u53f7 {}, \u5de5\u4f5c\u6d41\u8fd4\u56de {}", (Object)applyNo, (Object)processInfo);
        }
    }

    private void sendMessage(SaleInvDO saleInvDO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDO.getId());
        messageDTO.setCode(saleInvDO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        try {
            this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            throw new com.elitescloud.boot.exception.BusinessException("\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25");
        }
    }
}

