package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/11
 */
@Data
@ApiModel("开票配置保存或更新")
public class InvoiceRuleConfigSaveParam extends BaseViewModel {

    @ApiModelProperty("适用单据 [UDC]yst-supp:DOC_CLS")
    private String optDocCls;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    private String optDocType;

    @ApiModelProperty("可开票单据状态 [UDC]yst-franchisee:PAYMENT_STATUS")
    private String optDocStatus;

    @ApiModelProperty("可开票时限（天）")
    private Integer invoiceLimit;

    @ApiModelProperty(value = "是否自动开票 1-是 0-否")
    private Integer autoInvoice;

    @ApiModelProperty(value = "是否自动审核 1-是 0-否")
    private Integer autoReview;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty(value = "发票红冲前是否需要换开申请审核 1-是 0-否")
    private Integer needRedraft;

    @ApiModelProperty(value = "是否允许修改发票抬头 1-是 0-否")
    private Integer editInvTitle;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

}
