package com.elitesland.fin.domain.service.creditaccount;


import com.elitesland.fin.domain.base.BaseRepo;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDtlDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigDtlRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigDtlRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Service
@AllArgsConstructor
public class CreditAccountRuleConfigDtlDomainServiceImpl implements CreditAccountRuleConfigDtlDomainService {

    private final CreditAccountRuleConfigDtlRepo accountRuleConfigDtlRepo;

    private final CreditAccountRuleConfigDtlRepoProc accountRuleConfigDtlRepoProc;

    @Override
    public BaseRepo<CreditAccountRuleConfigDtlDO, Long> getDao() {
        return accountRuleConfigDtlRepo;
    }

    @Override
    public void updateDynamically(List<CreditAccountRuleConfigDtlDO> invSceneConfigDtlDOS) {
        accountRuleConfigDtlRepoProc.updateDynamically(invSceneConfigDtlDOS);
    }

    @Override
    public List<CreditAccountRuleConfigDtlDO> findAccountRuleConfigDtlByMasId(Long masId) {
        return accountRuleConfigDtlRepo.findByMasId(masId);
    }

    @Override
    public void deleteByParam(CreditAccountRuleConfigDtlDO accountRuleConfigDtlDO) {
        accountRuleConfigDtlRepoProc.deleteByParam(accountRuleConfigDtlDO);
    }
}