package com.elitesland.fin.infr.dto.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.dto.arorder
 * @date 2022/4/12 16:30
 */
@Data
public class ArOrderDTO implements Serializable {

    private static final long serialVersionUID = 4939372596527995873L;
    private Long id;

    private String sourceNo;

    private String arOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long arTypeId;

    private String arTypeName;

    private String arTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long custId;

    private String custCode;

    private String custName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String verState;

    private BigDecimal verAmt;

    private BigDecimal totalCount;

    private Long orgId;

    private String orgCode;

    private String orgName;

    private Long saleUserId;

    private String saleUser;

    private String arOrderType;

    private BigDecimal unVerAmt;

    private String creator;

    private LocalDateTime createTime;

    private String updater;

    private String remark;

    private LocalDateTime modifyTime;

    private Integer auditDataVersion;

    List<ArOrderDtlDTO> arOrderDtlDTOList;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String docType;

    private String docType2;

    private String docCls;

    @ApiModelProperty("结算方式")
    @SysCode(sys = "yst-fin", mod = "SETTLEMENT_TYPE")
    private String settlementType;
    private String settlementTypeName;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    private String proposedStatus;
    private String proposedStatusName;

    @ApiModelProperty("订单客户")
    private String es1;

    @ApiModelProperty("发票号")
    private String es2;

    @ApiModelProperty("开票日期")
    private LocalDateTime es3;

    @ApiModelProperty("发票类型")
    private String es4;

    @ApiModelProperty("起算日期")
    private LocalDateTime es5;

    @ApiModelProperty("红冲标志")
    private String es6;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    @ApiModelProperty("收款协议名称")
    private String protocolName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;
}
