package com.elitesland.fin.application.facade.vo.app;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/14
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "storeAccountCustAppVO",description = "门店账户的客户信息")
public class StoreAccountCustAppVO implements Serializable {

    /** 门店客户(子客户)编码*/
    @ApiModelProperty(name = "门店客户(子客户)编码")
    private String custCode ;
    /** 门店客户(子客户)名称 */
    @ApiModelProperty(name = "门店客户(子客户)名称")
    private String custName ;
    /** 门店客户的主客户编码*/
    @ApiModelProperty(name = "门店客户的主客户编码")
    private String storeCustCode ;
    /** 门店客户的主客户名称 */
    @ApiModelProperty(name = "门店客户的主客户名称")
    private String storeCustName ;

    /** 门店客户的主客户是否是外部客户*/
    @ApiModelProperty(name = "门店客户的主客户是否是外部客户")
    private Boolean storeCustType2Flag;

    @ApiModelProperty("内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

}
